! Inform / INFSP 6


!!==============================================================================
!!
!!	LIBRERA DE MENSAJES
!!	Permite imprimir mensajes en presente o pasado y en 1a, 2a o 3a persona.
!!
!!==============================================================================
!!
!!
!!	File:			FlexibleSpanish.h
!!	Author(s):		J. Francisco Martn (jfm.lisaso@gmail.com)
!!	Language:		ES (Castellano)
!!	System:			Inform/INFSP 6
!!	Platform:		Mquina-Z / GLULX
!!	Release:		1
!!	Released:		2010/12/13
!!	Notes:
!!
!!		Algunos mensajes han sido modificados expresamente para "La pequea 
!!		cerillera": [Attack, Dig, Eat, Jump, Pray, Quit, Restart, Sing, Strong, 
!!		Wait, WaveHands]
!!
!!
!!------------------------------------------------------------------------------
!!
!!
!!	Este programa es software libre: usted puede redistribuirlo y/o 
!!	modificarlo bajo los trminos de la Licencia Pblica General GNU 
!!	publicada por la Fundacin para el Software Libre, ya sea la versin 
!!	3 de la Licencia, o (a su eleccin) cualquier versin posterior.
!!
!!	Este programa se distribuye con la esperanza de que sea til, pero 
!!	SIN GARANTA ALGUNA; ni siquiera la garanta implcita MERCANTIL o 
!!	de APTITUD PARA UN PROPSITO DETERMINADO. Consulte los detalles de 
!!	la Licencia Pblica General GNU para ms informacin.
!!
!!	Debera haber recibido una copia de la Licencia Pblica General GNU 
!!	junto a este programa. En caso contrario, consulte
!!	<http://www.gnu.org/licenses/>.
!!
!!	Copyright (c) 2010, J. Francisco Martn
!!
!!
!!------------------------------------------------------------------------------
System_file;


!!------------------------------------------------------------------------------
!! Constantes y valores por defecto para los formatos de texto (st_texto)
!!------------------------------------------------------------------------------


Constant _STR_	= 0;
Constant _STI_	= 1;
Constant _STB_	= 3;
Constant _STM_	= 2;

Default	STPARSER_STYLE _STR_;
Default	STPARSER_MSG1 "";
Default	STPARSER_MSG2 "";


!!------------------------------------------------------------------------------
!! Variables empleadas por la librera de mensajes
!!------------------------------------------------------------------------------


Default	GRAMMATICAL_FLEXION = 2;	! Mensajes por defecto en presente, 2a pers.
Default	FORMER__TX		= "tu antiguo ~yo~";
Default	YOURSELF__TX	= "ti mismo";
Default	CANTGO__TX		= "No puedes ir por ah.";
Default	IS__TX			= " hay";
Default	ARE__TX			= " hay";
Default	IS2__TX			= "hay ";
Default	ARE2__TX		= "hay ";
Default	YOU__TX			= "T";
Default	PARTICULA_TE	= "te";


!!------------------------------------------------------------------------------
!! Seleccionar formato de texto (st_texto)
!!------------------------------------------------------------------------------


#Ifdef	TARGET_ZCODE;
[ st_normal;	font on; style roman; ];	!! Set style - normal
[ st_cursiva;	style underline; ];			!! Set style - cursiva
[ st_negrita;	style bold; ];				!! Set style - negrita
[ st_espaciada;	font off; ];				!! Set style - espaciada
#Ifnot;
[ st_normal;	glk($0086, 0); ];			!! Set style - normal
[ st_cursiva;	glk($0086, 1); ];			!! Set style - cursiva
[ st_negrita;	glk($0086, 3); ];			!! Set style - negrita
[ st_espaciada;	glk($0086, 2); ];			!! Set style - espaciada
#Endif;


[ st_parser;								!! Para mensajes del 'parser'
	switch ( STPARSER_STYLE ) {
		_STR_:	st_normal();
		_STI_:	st_cursiva();
		_STB_:	st_negrita();
		_STM_:	st_espaciada();
	}
];


!!------------------------------------------------------------------------------
!! Imprimir texto en diferentes formatos (st_texto)
!!------------------------------------------------------------------------------


#Ifdef	TARGET_ZCODE;
[ stcursiva text;
    if (text==0) return false;
    style underline;
    print (string) text;
    style roman;
    return true;
];
[ stnegrita text;
    if (text==0) return false;
    style bold;
    print (string) text;
    style roman;
    return true;
];
[ stespaciada text;
    if (text==0) return false;
    font off;
    print (string) text;
    font on;
    return true;
];
[ stparser text;
	if (text==0) return false;
	st_parser();
	if (STPARSER_MSG1~=0) print (string) STPARSER_MSG1;
	print (string) text;
	if (STPARSER_MSG2~=0) print (string) STPARSER_MSG2;
	st_normal();
	return true;
];
#Ifnot;	!! TARGET_GLULX
[ stcursiva text;
    if (text==0) return false;
    glk($0086, 1);
    print (string) text;
    glk($0086, 0);
    return true;
];
[ stnegrita text;
    if (text==0) return false;
    glk($0086, 3);
    print (string) text;
    glk($0086, 0);
    return true;
];
[ stespaciada text;
    if (text==0) return false;
    glk($0086, 2);
    print (string) text;
    glk($0086, 0);
    return true;
];
[ stparser text;
	if (text==0) return false;
	st_parser();
	if (STPARSER_MSG1~=0) print (string) STPARSER_MSG1;
	print (string) text;
	if (STPARSER_MSG2~=0) print (string) STPARSER_MSG2;
	st_normal();
	return true;
];
#Endif;
[ sti text; return stcursiva(text); ];
[ stb text; return stnegrita(text); ];
[ stp text; return stespaciada(text); ];
[ sta text; return stparser(text); ];


!!------------------------------------------------------------------------------
!! Modifica la conjugacin gramatical de los mensajes de la librera.
!!------------------------------------------------------------------------------
[ SetGrammaticalFlexion gf gender;
	if ( gender == 0 ) {	!! gnero masculino
		switch ( gf ) {
		1:	GRAMMATICAL_FLEXION = 1;
			FORMER__TX		= "mi antiguo ~yo~";
			YOURSELF__TX	= "mi mismo";
			CANTGO__TX		= "No puedo ir por ah.";
			IS__TX			= " hay";
			ARE__TX			= " hay";
			IS2__TX			= "hay ";
			ARE2__TX		= "hay ";
			YOU__TX			= "Yo";
			PARTICULA_TE	= "me";
		2:	GRAMMATICAL_FLEXION = 2;
			FORMER__TX		= "tu antiguo ~yo~";
			YOURSELF__TX	= "ti mismo";
			CANTGO__TX		= "No puedes ir por ah.";
			IS__TX			= " hay";
			ARE__TX			= " hay";
			IS2__TX			= "hay ";
			ARE2__TX		= "hay ";
			YOU__TX			= "T";
			PARTICULA_TE	= "te";
		3:	GRAMMATICAL_FLEXION = 3;
			FORMER__TX		= "su antiguo ~yo~";
			YOURSELF__TX	= "si mismo";
			CANTGO__TX		= "No puede ir por ah.";
			IS__TX			= " hay";
			ARE__TX			= " hay";
			IS2__TX			= "hay ";
			ARE2__TX		= "hay ";
			YOU__TX			= "l";
			PARTICULA_TE	= "se";
		4:	GRAMMATICAL_FLEXION = 4;
			FORMER__TX		= "mi antiguo ~yo~";
			YOURSELF__TX	= "mi mismo";
			CANTGO__TX		= "No poda ir por ah.";
			IS__TX			= " haba";
			ARE__TX			= " haba";
			IS2__TX			= "haba ";
			ARE2__TX		= "haba ";
			YOU__TX			= "Yo";
			PARTICULA_TE	= "me";
		5:	GRAMMATICAL_FLEXION = 5;
			FORMER__TX		= "tu antiguo ~yo~";
			YOURSELF__TX	= "ti mismo";
			CANTGO__TX		= "No podas ir por ah.";
			IS__TX			= " haba";
			ARE__TX			= " haba";
			IS2__TX			= "haba ";
			ARE2__TX		= "haba ";
			YOU__TX			= "T";
			PARTICULA_TE	= "te";
		6:	GRAMMATICAL_FLEXION = 6;
			FORMER__TX		= "su antiguo ~yo~";
			YOURSELF__TX	= "si mismo";
			CANTGO__TX		= "No poda ir por ah.";
			IS__TX			= " haba";
			ARE__TX			= " haba";
			IS2__TX			= "haba ";
			ARE2__TX		= "haba ";
			YOU__TX			= "l";
			PARTICULA_TE	= "se";
			}
		} else {				!! gnero femenino
			switch ( gf ) {
		1:	GRAMMATICAL_FLEXION = 1;
			FORMER__TX		= "mi antigua ~yo~";
			YOURSELF__TX	= "mi misma";
			CANTGO__TX		= "No puedo ir por ah.";
			IS__TX			= " hay";
			ARE__TX			= " hay";
			IS2__TX			= "hay ";
			ARE2__TX		= "hay ";
			YOU__TX			= "Yo";
			PARTICULA_TE	= "me";
		2:	GRAMMATICAL_FLEXION = 2;
			FORMER__TX		= "tu antigua ~yo~";
			YOURSELF__TX	= "ti misma";
			CANTGO__TX		= "No puedes ir por ah.";
			IS__TX			= " hay";
			ARE__TX			= " hay";
			IS2__TX			= "hay ";
			ARE2__TX		= "hay ";
			YOU__TX			= "T";
			PARTICULA_TE	= "te";
		3:	GRAMMATICAL_FLEXION = 3;
			FORMER__TX		= "su antigua ~yo~";
			YOURSELF__TX	= "si misma";
			CANTGO__TX		= "No puede ir por ah.";
			IS__TX			= " hay";
			ARE__TX			= " hay";
			IS2__TX			= "hay ";
			ARE2__TX		= "hay ";
			YOU__TX			= "Ella";
			PARTICULA_TE	= "se";
		4:	GRAMMATICAL_FLEXION = 4;
			FORMER__TX		= "mi antigua ~yo~";
			YOURSELF__TX	= "mi misma";
			CANTGO__TX		= "No poda ir por ah.";
			IS__TX			= " haba";
			ARE__TX			= " haba";
			IS2__TX			= "haba ";
			ARE2__TX		= "haba ";
			YOU__TX			= "Yo";
			PARTICULA_TE	= "me";
		5:	GRAMMATICAL_FLEXION = 5;
			FORMER__TX		= "tu antigua ~yo~";
			YOURSELF__TX	= "ti misma";
			CANTGO__TX		= "No podas ir por ah.";
			IS__TX			= " haba";
			ARE__TX			= " haba";
			IS2__TX			= "haba ";
			ARE2__TX		= "haba ";
			YOU__TX			= "T";
			PARTICULA_TE	= "te";
		6:	GRAMMATICAL_FLEXION = 6;
			FORMER__TX		= "su antigua ~yo~";
			YOURSELF__TX	= "si misma";
			CANTGO__TX		= "No poda ir por ah.";
			IS__TX			= " haba";
			ARE__TX			= " haba";
			IS2__TX			= "haba ";
			ARE2__TX		= "haba ";
			YOU__TX			= "Ella";
			PARTICULA_TE	= "se";
		}
	}
];


#Ifdef	DEBUG;
Verb	meta 'gramatica'
	*								-> Gramatica
	* number						-> Gramatica;
[ GramaticaSub;
	st_parser();
	if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
	switch (noun) {
		1:	SetGrammaticalFlexion( 1 ); print "Cambio de flexin gramatical: ";
		2:	SetGrammaticalFlexion( 2 ); print "Cambio de flexin gramatical: ";
		3:	SetGrammaticalFlexion( 3 ); print "Cambio de flexin gramatical: ";
		4:	SetGrammaticalFlexion( 4 ); print "Cambio de flexin gramatical: ";
		5:	SetGrammaticalFlexion( 5 ); print "Cambio de flexin gramatical: ";
		6:	SetGrammaticalFlexion( 6 ); print "Cambio de flexin gramatical: ";
		default: print "Flexin gramatical actual: ";
	}
	switch ( GRAMMATICAL_FLEXION ) {
		1:	print "(1) presente 1a persona";
		2:	print "(2) presente 2a persona";
		3:	print "(3) presente 3a persona";
		4:	print "(4) pasado 1a persona";
		5:	print "(5) pasado 2a persona";
		6:	print "(6) pasado 3a persona";
	}
	print ".";
	if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2;
	st_normal();
	new_line;
	return true;
];
#Endif;


!!------------------------------------------------------------------------------
!! Mensajes de la librera (basados en 'Spanish.h')
!!------------------------------------------------------------------------------
[LanguageLM n x1;

	Answer, Ask, AskFor, Order, Tell:
		print_ret (stparser) "Para iniciar una conversacin, usa 
		simplemente la orden HABLA (a/con) PERSONAJE.";

	! Ask:		mira Answer.
	! AskFor:	mira Answer.

	Attack:
		switch (GRAMMATICAL_FLEXION) {
!		1,2,3:	"La violencia no es la solucin.";
!		4,5,6:	"La violencia no era la solucin.";
		6:		"No tena fuerzas para hacer eso.";
		}

	Blow:
		switch (GRAMMATICAL_FLEXION) {
		1:	"Mi soplido no produce ningn efecto.";
		2:	"Tu soplido no produce ningn efecto.";
		3:	"Su soplido no produce ningn efecto.";
		4:	"Mi soplido no produjo ningn efecto.";
		5:	"Tu soplido no produjo ningn efecto.";
		6:	"Su soplido no produjo ningn efecto.";
		}

	Burn:
		switch (GRAMMATICAL_FLEXION) {
		1:	"Con esa peligrosa accin no iba a lograr nada.";
		2:	"Con esa peligrosa accin no ibas a lograr nada.";
		3:	"Con esa peligrosa accin no iba a lograr nada.";
		4:	"Con esa peligrosa accin no hubiese logrado nada.";
		5:	"Con esa peligrosa accin no hubieses logrado nada.";
		6:	"Con esa peligrosa accin no hubiese logrado nada.";
		}

	Buy:
		switch (GRAMMATICAL_FLEXION) {
		1,2,3:	"No hay nada en venta.";
		4,5,6:	"No haba nada en venta.";
		}

	Climb:
		switch (GRAMMATICAL_FLEXION) {
		1:	"No creo que vaya a lograr nada as.";
		2:	"No creo que vayas a lograr nada as.";
		3:	"No creo que vaya a lograr nada as.";
		4:	"No creo que hubiese logrado nada as.";
		5:	"No creo que hubieses logrado nada as.";
		6:	"No creo que hubiese logrado nada as.";
		}

	Close:
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No es algo que pueda cerrarse.";
				4,5,6:	"No era algo que se pudiese cerrar.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	"Cierro ", (the) x1 ,".";
				2:	"Cierras ", (the) x1, ".";
				3:	"Cierra ", (the) x1, ".";
				4:	"Cerr ", (the) x1, ".";
				5:	"Cerraste ", (the) x1, ".";
				6:	"Cerr ", (the) x1, ".";
				}
		}

	CommandsOff: switch (n) { ! [6/11]
		1:	print_ret (stparser) "Grabacin de rdenes finalizada.";
		#Ifdef TARGET_GLULX;
		2:	print_ret (stparser) "Grabacin de rdenes ya estaba finalizada.";
		#Endif; ! TARGET_
	}

	CommandsOn: switch (n) { ! [6/11]
		1:	print_ret (stparser) "Grabacin de rdenes activada.";
		#Ifdef TARGET_GLULX;
		2:	print_ret (stparser) "rdenes relanzadas.";
		3:	print_ret (stparser) "Grabacin de rdenes ya activada.";
		4:	print_ret (stparser) "Fallo en la grabacin de rdenes.";
		#Endif; ! TARGET_
	}

	CommandsRead: switch (n) { ! [6/11]
		1:	print_ret (stparser) "Relanzando acciones.";
		#Ifdef TARGET_GLULX;
		2:	print_ret (stparser) "Las rdenes ya estn siendo relanzadas.";
		3:	print_ret (stparser) "Fallo en la reejecucin de rdenes: 	
			grabacin en curso.";
		4:	print_ret (stparser) "Fallo en la reejecucin de rdenes.";
		5:	print_ret (stparser) "Acciones ejecutadas: fin del proceso.";
		#Endif; ! TARGET_
	}

	Consult:
		switch (GRAMMATICAL_FLEXION) {
		1: "No descubro nada interesante en ", (the) x1 ," sobre ese tema.";
		2: "No descubres nada interesante en ", (the) x1, " sobre ese tema.";
		3: "No descubre nada interesante en ", (the) x1, " sobre ese tema.";
		4: "No descubr nada interesante en ", (the) x1, " sobre ese tema.";
		5: "No descubriste nada interesante en ",(the) x1, " sobre ese tema.";
		6: "No descubri nada interesante en ", (the) x1, " sobre ese tema.";
		}

	Cut:
		switch (GRAMMATICAL_FLEXION) {
		1:	"Cortndo", (lo) x1, " no lograr gran cosa.";
		2:	"Cortndo", (lo) x1, " no logrars gran cosa.";
		3:	"Cortndo", (lo) x1, " no lograr gran cosa.";
		4:	"Cortndo", (lo) x1, " no hubiese logrado gran cosa.";
		5:	"Cortndo", (lo) x1, " no hubieses logrado gran cosa.";
		6:	"Cortndo", (lo) x1, " no hubiese logrado gran cosa.";
		}

	Dig:
		switch (GRAMMATICAL_FLEXION) {
!		1,2,3:	"Excavar no servir de nada aqu.";
!		4,5,6:	"Excavar no hubiese servido de nada all.";
		6:		"No estaba ella para jugar con la nieve.";
		}

	Disrobe:
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"No llevo eso puesto.";
				2:	"No llevas eso puesto.";
				3:	"No lleva eso puesto.";
				4:	"No llevaba eso puesto.";
				5:	"No llevabas eso puesto.";
				6:	"No llevaba eso puesto.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"Me quito ", (the) x1 ,".";
				2:	"Te quitas ", (the) x1, ".";
				3:	"Se quita ", (the) x1, ".";
				4:	"Me quit ", (the) x1, ".";
				5:	"Te quitaste ", (the) x1, ".";
				6:	"Se quit ", (the) x1, ".";
				}
	}

	Drink:
		switch (GRAMMATICAL_FLEXION) {
		1,2,3:	"Eso no parece potable.";
		4,5,6:	"Eso no pareca potable.";
		}

	Drop:
		!!	1:	Error, el objeto dejado no est en poder del jugador, pero est 
		!!		en la localidad.
		!!	2:	Error, el objeto dejado no est en poder del jugador ni en la 
		!!		localidad,
		!!	3:	Aviso, el objeto era una prenda que el jugador llevaba puesta y 
		!!		la librera va a quitrsela automticamente para poder dejarla.
		!!	4:	xito.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"Para dejar ", (the) x1, " debera tener", (lo) x1 ,".";
				2:	"Para dejar ", (the) x1, " deberas tener", (lo) x1,".";
				3:	"Para dejar ", (the) x1, " debera tener", (lo) x1, ".";
				4:	"Para dejar ", (the) x1, " hubiese debido tener",
					(lo) x1, ".";
				5:	"Para dejar ", (the) x1, " hubieses debido tener", 
					(lo) x1, ".";
				6:	"Para dejar ", (the) x1, " hubiese debido tener", 
					(lo) x1, ".";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No ", (lo) x1, " tengo.";
				2:	"No ", (lo) x1, " tienes.";
				3:	"No ", (lo) x1, " tiene.";
				4:	"No ", (lo) x1, " tena.";
				5:	"No ", (lo) x1, " tenas.";
				6:	"No ", (lo) x1, " tena.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	"(Primero me quito ", (the) x1, ".)";
				2:	"(Primero te quitas ", (the) x1, ".)";
				3:	"(Primero se quita ", (the) x1, ".)";
				4:	"(Primero me quit ", (the) x1, ".)";
				5:	"(Primero te quitaste ", (the) x1, ".)";
				6:	"(Primero se quit ", (the) x1, ".)";
				}
			4:	"Dejad", (o) x1 ,".";
		}

	Eat:
		!!	1:	Error, el objeto no tiene el atributo "edible".
		!!	2:	xito.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
!				1, 2, 3:	"Eso es simplemente incomestible.";
!				4, 5, 6:	"Eso era simplemente incomestible.";
				6:	"Tena muchsimo hambre, pero eso era simplemente 
					incomestible.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1: "Me como ", (the) x1 ,". No est", (n) x1, " mal.";
				2: "Te comes ", (the) x1, ". No est", (n) x1, " mal.";
				3: "Se come ", (the) x1, ". No est", (n) x1, " mal.";
				4: "Me com ", (the) x1, ". No estaba", (n) x1, " mal.";
				5: "Te comiste ", (the) x1, ". No estaba", (n) x1, " mal.";
				6: "Se comi ", (the) x1, ". No estaba", (n) x1, " mal.";
				}
		}

	EmptyT:
		!!	1:	Error, el jugador intenta vaciar un objeto en otro que no es un 
		!!		recipiente.
		!!	2:	Error, el jugador intenta vaciar un objeto sobre un recipiente 
		!!		cerrado.
		!!	3:	Error, el jugador intenta vaciar un objeto que no tiene nada 
		!!		dentro.
		!!	4:	Error, el jugador intenta vaciar un objeto sobre s mismo.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print_ret (The) x1, " no puede", (n) x1, " tener 
						cosas dentro.";
				4,5,6:	print_ret (The) x1, " no poda", (n) x1, " tener 
						cosas dentro.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print_ret (The) x1, " est", (n) x1, " cerrad", 
						(o) x1, ".";
				4,5,6:	print_ret (The) x1, " estaba", (n) x1, " cerrad",
						(o) x1, ".";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print_ret (The) x1, " ya est", (n) x1," vac", 
						(o) x1, ".";
				4,5,6:	print_ret (The) x1, " ya estaba", (n) x1, " vac",
						(o) x1, ".";
				}
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo vaciar un objeto sobre s mismo.";
				2:	"No puedes vaciar un objeto sobre s mismo.";
				3:	"No puede vaciar un objeto sobre s mismo.";
				4:	"No poda vaciar un objeto sobre s mismo.";
				5:	"No podas vaciar un objeto sobre s mismo.";
				6:	"No poda vaciar un objeto sobre s mismo.";
				}
	}

	Enter: 
		!!	1:	Error, el jugador ya est en/sobre el objeto.
		!!	2:	Error, el objeto al que intenta entrar/subirse el jugador no 
		!!		tiene el atributo "enterable".
		!!	3:	Error, el objeto al que intenta entrar/subirse el jugador tiene 
		!!		los atributos "container" y "enterable", pero est cerrado.
		!!	4:	Error, el objeto al que intenta entrar/subirse el jugador est 
		!!		en poder del propio jugador.
		!!	5:	xito, el jugador entra/sube al objeto.
		!!	6:	Aviso, el jugador estaba en otro objeto, la lib. intentar la 
		!!		accin SALIR automticamente antes de reintentar entrar el 
		!!		nuevo objeto.
		!!	7:	Aviso, el objeto al que intenta entrar/subirse el jugador est 
		!!		dentro de otros objeto. La lib. intentar automticamente meter 
		!!		al jugador en el objeto desde el cual pueda acceder al que el 
		!!		jugador le ha indicado.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,4:	print "Ya estaba ";
				2,5:	print "Ya estabas ";
				3,6:	print "Ya estaba ";
				}
				if (x1 has supporter) print "sobre "; else print "en ";
				print_ret (the) x1, ".";
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No es algo donde pueda entrar.";
				2:	"No es algo donde puedas entrar.";
				3:	"No es algo donde pueda entrar.";
				4:	"No era algo donde pudiese entrar.";
				5:	"No era algo donde pudieses entrar.";
				6:	"No era algo donde pudiese entrar.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo entrar en ", (the) x1 ," porque est", 
					(n) x1, " cerrad", (o) x1 ,".";
				2:	"No puedes entrar en ", (the) x1, " porque est", 
					(n) x1, " cerrad", (o) x1, ".";
				3:	"No puede entrar en ", (the) x1, " porque est", 
					(n) x1, " cerrad", (o) x1, ".";
				4:	"No poda entrar en ", (the) x1, " porque estaba", 
					(n) x1, " cerrad", (o) x1, ".";
				5:	"No podas entrar en ", (the) x1, " porque estaba", 
					(n) x1, " cerrad", (o) x1, ".";
				6:	"No poda entrar en ", (the) x1, " porque estaba", 
					(n) x1, " cerrad", (o) x1, ".";
				}
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo entrar ah mientras no lo suelte."; 
				2:	"No puedes entrar ah mientras no lo sueltes.";
				3:	"No puede entrar ah mientras no lo suelte.";
				4:	"No poda entrar ah mientras no lo soltase.";
				5:	"No podas entrar ah mientras no lo soltases.";
				6:	"No poda entrar ah mientras no lo soltase.";
				}
			5:	switch (GRAMMATICAL_FLEXION) {
				1:	if (x1 has supporter) print "Subo ", (al) x1;
					else print "Entro en ", (the) x1;
					".";
				2:	if (x1 has supporter) print "Subes ", (al) x1;
					else print "Entras en ", (the) x1;
					".";
				3:	if (x1 has supporter) print "Sube ", (al) x1;
					else print "Entra en ", (the) x1;
					".";
				4:	if (x1 has supporter) print "Sub ", (al) x1;
					else print "Entr en ", (the) x1;
					".";
				5:	if (x1 has supporter) print "Subiste ", (al) x1;
					else print "Entraste en ", (the) x1;
					".";
				6:	if (x1 has supporter) print "Subi ", (al) x1;
					else print "Entr en ", (the) x1;
					".";
				}
			6:	switch (GRAMMATICAL_FLEXION) {
				1:	if (x1 has supporter) print "(Me bajo ";
					else print "(Salgo ";
				2:	if (x1 has supporter) print "(Te bajas ";
					else print "(Sales ";
				3:	if (x1 has supporter) print "(Se baja ";
					else print "(Sale ";
				4:	if (x1 has supporter) print "(Me baj ";
					else print "(Sal ";
				5:	if (x1 has supporter) print "(Te bajaste ";
					else print "(Saliste ";
				6:	if (x1 has supporter) print "(Se baj ";
					else print "(Sali ";
				} print_ret (del) x1, ".)";
			7:	switch (GRAMMATICAL_FLEXION) {
				1:	if (x1 has supporter) "(Me subo ", (al) x1, ".)^";
					if (x1 has container) "(Me meto en ", (the) x1, ".)^";
					"(Entro en ", (the) x1, ".)^";
				2:	if (x1 has supporter) "(Te subes ", (al) x1, ".)^";
					if (x1 has container) "(Te metes en ", (the) x1, ".)^";
					"(Entras en ", (the) x1, ".)^";
				3:	if (x1 has supporter) "(Se sube ", (al) x1, ".)^";
					if (x1 has container) "(Se mete en ", (the) x1, ".)^";
					"(Entra en ", (the) x1, ".)^";
				4:	if (x1 has supporter) "(Me sub ", (al) x1, ".)^";
					if (x1 has container) "(Me met en ", (the) x1, ".)^";
					"(Entr en ", (the) x1, ".)^";
				5:	if (x1 has supporter) "(Te subiste ", (al) x1, ".)^";
					if (x1 has container) "(Te metiste en ", (the) x1,".)^";
					"(Entraste en ", (the) x1, ".)^";
				6:	if (x1 has supporter) "(Se subi ", (al) x1, ".)^";
					if (x1 has container) "(Se meti en ", (the) x1, ".)^";
					"(Entr en ", (the) x1, ".)^";
				}
		}

	Examine:
		!!	1:	Error, el jugador intenta examinar un objeto, pero est a 
		!!		oscuras.
		!!	2:	xito, pero el objeto examinado no tiene descripcion
		!!	3:	xito, pero el objeto examinado no tiene descripcion, aunque 
		!!		tiene el atributo conmutable, por lo que la librera genera 
		!!		este mensaje para indicar si est apagado o encendido.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"Est demasiado oscuro, no puedo ver nada.";
				2:	"Est demasiado oscuro, no puedes ver nada.";
				3:	"Est demasiado oscuro, no puede ver nada.";
				4:	"Estaba demasiado oscuro, no poda ver nada.";
				5:	"Estaba demasiado oscuro, no podas ver nada.";
				6:	"Estaba demasiado oscuro, no poda ver nada.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No observo nada especial en ", (the) x1, ".";
				2:	"No observas nada especial en ", (the) x1, ".";
				3:	"No observa nada especial en ", (the) x1, ".";
				4:	"No v nada especial en ", (the) x1, ".";
				5:	"No viste nada especial en ", (the) x1, ".";
				6:	"No vi nada especial en ", (the) x1, ".";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print (The) x1, " est", (n) x1;
				4,5,6:	print (The) x1, " estaba", (n) x1;
				}
				if (x1 has on) " encendid", (o) x1, "."; 
				else " apagad", (o) x1,".";
		}

	Exit:
		!!	1:	Error, el jugador no est subido/sentado/metido en ningn 
		!!		objeto.
		!!	2:	Error, el jugador est dentro de un recipiente cerrado.
		!!	3:	xito, el jugador sale/baja del objeto.
		!!	4:	Error, mas especifico. [6/11]
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"No estoy en ningn sitio del que deba salir.";
				2:	"No ests en ningn sitio del que debas salir.";
				3:	"No est en ningn sitio del que deba salir.";
				4:	"No estaba en ningn sitio del que debiese salir.";
				5:	"No estabas en ningn sitios del que debieses salir.";
				6:	"No estaba en ningn sitio del que debiese salir.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo salir ", (del) x1, " porque est", (n) x1, 
					" cerrad", (o) x1, ".";
				2:	"No puedes salir ", (del) x1, " porque est", (n) x1,
					" cerrad", (o) x1, ".";
				3:	"No puede salir ", (del) x1, " porque est", (n) x1,
					" cerrad", (o) x1, ".";
				4:	"No poda salir ", (del) x1, " porque estaba", (n) x1,
					" cerrad", (o) x1, ".";
				5:	"No podas salir ", (del) x1, " porque estaba", (n) x1,
					" cerrad", (o) x1, ".";
				6:	"No poda salir ", (del) x1, " porque estaba", (n) x1,
					" cerrad", (o) x1, ".";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	if (x1 has supporter) print "Bajo "; 
					else print "Salgo ";
				2:	if (x1 has supporter) print "Bajas "; 
					else print "Sales ";
				3:	if (x1 has supporter) print "Baja "; 
					else print "Sale ";
				4:	if (x1 has supporter) print "Baj "; 
					else print "Sal ";
				5:	if (x1 has supporter) print "Bajaste "; 
					else print "Saliste ";
				6:	if (x1 has supporter) print "Baj "; 
					else print "Sali ";
				} print_ret (del) x1, ".";
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Pero si no estoy ";
				2:	print "Pero si no ests ";
				3:	print "Pero si no est ";
				4:	print "Pero si no estaba ";
				5:	print "Pero si no estabas ";
				6:	print "Pero si no estaba ";
				}
				if (x1 has supporter) print "encima  "; else print "dentro ";
				print_ret (del) x1, ".";
		}

	Fill:
		switch (GRAMMATICAL_FLEXION) {
		1:	"No puedo llenar", (lo) x1, ".";
		2:	"No puedes llenar", (lo) x1, ".";
		3:	"No puede llenar", (lo) x1, ".";
		4:	"No poda llenar", (lo) x1, ".";
		5:	"No podas llenar", (lo) x1, ".";
		6:	"No poda llenar", (lo) x1, ".";
		}

	FullScore:
		!!	1:	Texto introductorio al desglose de puntos.
		!!	2:	Texto de objetos importantes.
		!!	3:	Texto de lugares importantes.
		!!	4:	Texto final, tras la suma total impresa por la librera.
		switch (n) {
			1:	if (deadflag)	print "La puntuacin se desglos ";
				else			print "La puntuacin se desglosa ";
				"de la siguiente manera:^";
			2:	"por encontrar objetos importantes";
			3:	"por visitar lugares importantes";
			4:	print "total (de ", MAX_SCORE ; ")";
		}
		return true;

	GetOff:
		!! Esta accin se genera ante la frase SAL DEL ARMARIO o similares. 
		!! Ante SAL a secas la accin es Salir. Si el jugador no est en el 
		!! objeto indicado, se genera el siguiente mensaje de error. Si est, 
		!! la librera generar una accin Salir, por lo que el mensaje de 
		!! xito ser el de Salir.
		switch (GRAMMATICAL_FLEXION) {
		1:	"Si ni siquiera estoy en ", (the) x1 ,".";
		2:	"Si ni siquiera ests en ", (the) x1, ".";
		3:	"Si ni siquiera est en ", (the) x1, ".";
		4:	"Si ni siquiera estaba en ", (the) x1, ".";
		5:	"Si ni siquiera estabas en ", (the) x1, ".";
		6:	"Si ni siquiera estaba en ", (the) x1, ".";
		}

	Give:
		!!	1:	Error, el jugador intenta dar un objeto que no tiene.
		!!	2:	Error, el jugador se da el objeto a s mismo.
		!!	3:	Aviso, se ha enviado la accin Dar al PNJ, pero este no ha
		!!		respondido. En este caso x1 apunta al PNJ y no al objeto
		!!		que le hemos dado.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"No tengo ", (the) x1, ".";
				2:	"No tienes ", (the) x1, ".";
				3:	"No tiene ", (the) x1, ".";
				4:	"No tena ", (the) x1, ".";
				5:	"No tenas ", (the) x1, ".";
				6:	"No tena ", (the) x1, ".";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"Manoseo ", (the) x1, " durante un rato, sin consiguir 
					nada.";
				2:	"Manoseas ", (the) x1, " durante un rato, sin conseguir 
					nada.";
				3:	"Manosea ", (the) x1, " durante un rato, sin conseguir 
					nada.";
				4:	"Manose ", (the) x1, " durante unos momentos, sin 
					conseguir nada.";
				5:	"Manoseaste ", (the) x1, " durante unos momentos, sin 
					conseguir nada.";
				6:	"Manose ", (the) x1, " durante unos momentos, sin 
					conseguir nada.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print_ret (The) x1, " no parece", (n) x1, 
						" interesad", (o) x1, ".";
				4,5,6:	print_ret (The) x1, " no pareca", (n) x1, 
						" interesad", (o) x1, ".";
				}
		}

	Go:
		!!	1:	Error, el jugador est dentro/subido en un objeto del que
		!!		tiene que salir antes.
		!!	2:	Error, la localidad no tiene salida en esa direccin (y tampoco 
		!!		tiene la propiedad "cant_go", ya que en este caso se habra 
		!!		impreso el valor de esa propiedad.
		!!	3:	Error, el jugador ha intentado ir hacia arriba, pero all hay 
		!!		una puerta cerrada.
		!!	4:	Error, el jugador ha intentado ir hacia abajo, pero all hay 
		!!		una puerta cerrada.
		!!	5:	Error, en la direccin que ha dicho el jugador hay una
		!!		puerta cerrada.
		!!	6:	Error, en la direccin que ha dicho el jugador hay una puerta, 
		!!		pero sta no tiene una propiedad "door_to" (probablemente un 
		!!		error de programacin del juego).
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Tengo que ";
					if (x1 has supporter) print "bajarme ";
					else print "salir ";
				2:	print "Tienes que ";
					if (x1 has supporter) print "bajarte ";
					else print "salir ";
				3:	print "Tiene que ";
					if (x1 has supporter) print "bajarse ";
					else print "salir ";
				4:	print "Tena que ";
					if (x1 has supporter) print "bajarme ";
					else print "salir ";
				5:	print "Tenas que ";
					if (x1 has supporter) print "bajarte ";
					else print "salir ";
				6:	print "Tena que ";
					if (x1 has supporter) print "bajarse ";
					else print "salir ";
				}
				print_ret (del) x1, " antes.";
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo ir por ah.";
				2:	"No puedes ir por ah.";
				3:	"No puede ir por ah.";
				4:	"No poda ir por ah.";
				5:	"No podas ir por ah.";
				6:	"No poda ir por ah.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	"Soy incapaz de trepar por ", (the) x1, ".";
				2:	"Eres incapaz de trepar por ", (the) x1, ".";
				3:	"Es incapaz de trepar por ", (the) x1, ".";
				4:	"Era incapaz de trepar por ", (the) x1, ".";
				5:	"Eras incapaz de trepar por ", (the) x1, ".";
				6:	"Era incapaz de trepar por ", (the) x1, ".";
				}
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	"Soy incapaz de bajar por ", (the) x1, ".";
				2:	"Eres incapaz de bajar por ", (the) x1, ".";
				3:	"Es incapaz de bajar por ", (the) x1, ".";
				4:	"Era incapaz de bajar por ", (the) x1, ".";
				5:	"Eras incapaz de bajar por ", (the) x1, ".";
				6:	"Era incapaz de bajar por ", (the) x1, ".";
				}
			5:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo pasar a travs ", (del) x1, ".";
				2:	"No puedes pasar a travs ", (del) x1, ".";
				3:	"No puede pasar a travs ", (del) x1, ".";
				4:	"No poda pasar a travs ", (del) x1, ".";
				5:	"No podas pasar a travs ", (del) x1, ".";
				6:	"No poda pasar a travs ", (del) x1, ".";
				}
			6:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo ir porque ", (the) x1, " no lleva", (n) x1, 
					" a ningn sitio.";
				2:	"No puedes ir porque ", (the) x1, " no lleva", (n) x1, 
					" a ningn sitio.";
				3:	"No puede ir porque ", (the) x1, " no lleva", (n) x1, 
					" a ningn sitio.";
				4:	"No poda ir porque ", (the) x1, " no llevaba", (n) x1, 
					" a ningn sitio.";
				5:	"No podas ir porque ", (the) x1, " no llevaba", (n) x1,
					" a ningn sitio.";
				6:	"No poda ir porque ", (the) x1, " no llevaba", (n) x1, 
					" a ningn sitio.";
				}
		}

	Insert:
		!!	1:	Error, el objeto no est en poder del jugador. [Nota, conviene 
		!!		mirar en este caso si el objeto es animado o no, para generar 
		!!		un mensaje ms adecuado].
		!!	2:	Error, el jugador intenta meter el objeto en otro que no tiene 
		!!		el atributo "container".
		!!	3:	Error, el jugador intenta meter el objeto en un recipiente
		!!		cerrado.
		!!	4:	Error, el objeto es una prenda que el jugador lleva puesta.
		!!		[ESTE MENSAJE NO SE GENERA NUNCA, PARECE UN BUG DE LA LIBRERA. 
		!!		Vase en su lugar el mensaje 6].
		!!	5:	Error, se intenta poner un objeto dentro de s mismo.
		!!	6:	Aviso, el objeto es una prenda puesta, la librera va a 
		!!		quitrsela de forma automtica antes de reintentar Insert.
		!!	7:	Error, no queda sitio en el recipiente (el nmero de objetos 
		!!		que un recipiente puede contener se indica en su propiedad
		!!		"capacity").
		!!	8:	xito. Mensaje a mostrar para cada objeto metido cuando se
		!!		meten muchos (ej: METE TODO EN LA BOLSA).
		!!	9:	xito. Mensaje a mostrar cuando se mete un solo objeto dentro
		!!		de otro.
	    switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	if (x1 has animate)
						"Antes tendra que ", (coge)"rl", (o) x1, " y no s 
						si se dejar", (n) x1, ".";
					else
						"Necesito tener ", (the) x1, 
						" para poder meter", (lo) x1, 
						" donde sea.";
				2:	if (x1 has animate)
						"Antes tendras que ", (coge)"rl", (o) x1, " y no s 
						si se dejar", (n) x1, ".";
					else
						"Necesitas tener ", (the) x1, " para poder meter", 
						(lo) x1, " donde sea.";
				3:	if (x1 has animate)
						"Antes tendra que ", (coge)"rl", (o) x1, " y no s 
						si se dejar", (n) x1, ".";
					else
						"Necesita tener ", (the) x1, " para poder meter", 
						(lo) x1, " donde sea.";
				4:	if (x1 has animate)
						"Antes tendra que haber", (lo) x1, " cogido, y no 
						creo que ", (the) x1, " se hubiese", (n) x1, 
						" dejado.";
					else
						"Hubiese necesitado tener ", (the) x1, " para poder 
						meter", (lo) x1, " donde fuese.";
				5:	if (x1 has animate)
						"Antes tendras que haber", (lo) x1, " cogido, y no 
						creo que ", (the) x1, " se hubiese", (n) x1, 
						" dejado.";
					else
						"Hubieses necesitado tener ", (the) x1, " para poder 
						meter", (lo) x1, " donde fuese.";
				6:	if (x1 has animate)
						"Antes tendra que haber", (lo) x1, " cogido, y no 
						creo que ", (the) x1, " se hubiese", (n) x1, 
						" dejado.";
					else
						"Hubiese necesitado tener ", (the) x1, " para poder 
						meter", (lo) x1, " donde fuese.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No se pueden meter cosas dentro ", (del) x1, ".";
				4,5,6:	"No se podan meter cosas dentro ", (del) x1, ".";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print (The) x1, " est", (n) x1;
				4,5,6:	print (The) x1, " estaba", (n) x1;
				} " cerrad", (o) x1, ".";
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	"Tengo que quitrme", (lo) x1, " antes.";
				2:	"Tienes que quitrte", (lo) x1, " antes.";
				3:	"Tiene que quitrse", (lo) x1, " antes.";
				4:	"Tena que quitrme", (lo) x1, " antes.";
				5:	"Tenas que quitrte", (lo) x1, " antes.";
				6:	"Tena que quitrse", (lo) x1, " antes.";
				}
			5:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo poner un objeto dentro de s mismo.";
				2:	"No puedes poner un objeto dentro de s mismo.";
				3:	"No puede poner un objeto dentro de s mismo.";
				4:	"No poda poner un objeto dentro de s mismo.";
				5:	"No podas poner un objeto dentro de s mismo.";
				6:	"No poda poner un objeto dentro de s mismo.";
				}
			6:	switch (GRAMMATICAL_FLEXION) {
				1:	"(Primero me ", (lo) x1, " quito.)^";
				2:	"(Primero te ", (lo) x1, " quitas.)^";
				3:	"(Primero se ", (lo) x1, " quita.)^";
				4:	"(Primero me ", (lo) x1, " quit.)^";
				5:	"(Primero te ", (lo) x1, " quitaste.)^";
				6:	"(Primero se ", (lo) x1, " quit.)^";
				}
			7:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No queda sitio en ", (the) x1, ".";
				4,5,6:	"No quedaba sitio en ", (the) x1, ".";
				}
			8:	"Hecho.";
			9:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Meto ";	2:	print "Metes ";		3:	print "Mete ";
				4:	print "Met ";	5:	print "Metiste ";	6:	print "Meti ";
				} print_ret (the) x1, " dentro ", (del) second, ".";
    	}

	Inv:
		!!	1:	Mensaje si el inventario est vaco
		!!	2:	Encabezado del inventario, antes de la lista de objetos 
		!!		generada por la librera
		!!	3 y 4: [6/11]
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"No llevo nada.";
				2:	"No llevas nada.";
				3:	"No lleva nada.";
				4:	"No llevaba nada.";
				5:	"No llevabas nada.";
				6:	"No llevaba nada.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Llevo";
				2:	print "Llevas";
				3:	print "Lleva";
				4:	print "Llevaba";
				5:	print "Llevabas";
				6:	print "Llevaba";
				}
			3:	print ":^";
			4:	print ".^";
		}
		return true;

	Jump:
!		switch (GRAMMATICAL_FLEXION) {
!		1:	print "Salto";	2:	print "Saltas";		3:	print "Salta";
!		4:	print "Salt";	5:	print "Saltaste";	6:	print "Salt";
!		} " en el sitio, sin ningn resultado.";
		"No tena fuerzas para andar saltando sin motivo.";

	JumpOver, Tie:
		switch (GRAMMATICAL_FLEXION) {
		1:	"No lograr nada as.";
		2:	"No logrars nada as.";
		3:	"No lograr nada as.";
		4:	"No hubiese logrado nada as.";
		5:	"No hubieses logrado nada as.";
		6:	"No hubiese logrado nada as.";
		}

	Kiss:
		switch (GRAMMATICAL_FLEXION) {
		1:	"No creo que deba.";
		2:	"No creo que debas.";
		3:	"No creo que deba.";
		4:	"No habra hecho algo as en aquel momento.";
		5:	"No habras hecho algo as en aquel momento.";
		6:	"No habra hecho algo as en aquel momento.";
		}

	Listen:
		switch (GRAMMATICAL_FLEXION) {
		1:	"No escucho nada fuera de lo comn.";
		2:	"No escuchas nada fuera de lo comn.";
		3:	"No escucha nada fuera de lo comn.";
		4,5,6: "No se escuchaba nada fuera de lo comn.";
		}

	ListMiscellany:
		!! Los siguientes mensajes se muestran como aclaraciones cuando se est 
		!! listando el inventario del jugador, o los objetos que hay en una 
		!! localidad. Junto a cada mensaje se comenta qu condiciones deben 
		!! darse en ese objeto para que se muestre ese mensaje aclaratorio.
		switch (n) {
			1:	print " (alumbrando)";
			2:	switch (GRAMMATICAL_FLEXION) {
				1,2,3: print " (que est", (n) x1, " cerrad", (o) x1, ")";
				4,5,6: print " (que estaba", (n) x1, " cerrad", (o) x1, ")";
				}
			3:	print " (cerrad", (o) x1, " y alumbrando)";
			4:	switch (GRAMMATICAL_FLEXION) {
				1,2,3: print " (que est", (n) x1, " vac", (o) x1, ")";
				4,5,6: print " (que estaba", (n) x1, " vac", (o) x1, ")";
				}
			5:	print " (vac", (o) x1, " y alumbrando)";
			6:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print " (que est", (n) x1, " cerrad", (o) x1, 
						" y vac", (o) x1, ")";
				4,5,6:	print " (que estaba", (n) x1, " cerrad", (o) x1,
						" y vac", (o) x1, ")";
				}
			7:	print " (cerrad", (o) x1, ", vac", (o) x1, " y 
				alumbrando)";

			!!	Los casos siguientes son similares, pero se muestran cuando se 
			!!	solicita a la rutina EscribirListaDesde la opcin INFOTOTAL. La 
			!!	librera puede combinar varios de estos mensajes, por eso no 
			!!	deben llevar el cierre de parntesis al final, que lo aade la 
			!!	propia librara.

			8:	switch (GRAMMATICAL_FLEXION) {
				1:	print " (alumbrando y que llevo puest", (o) x1;
				2:	print " (alumbrando y que llevas puest", (o) x1;
				3:	print " (alumbrando y que lleva puest", (o) x1;
				4:	print " (alumbrando y que llevaba puest", (o) x1;
				5:	print " (alumbrando y que llevabas puest", (o) x1;
				6:	print " (alumbrando y que llevaba puest", (o) x1;
				}
			9:	print " (alumbrando";
			10:	switch (GRAMMATICAL_FLEXION) {
				1:	print " (que llevo puest", (o) x1;
				2:	print " (que llevas puest", (o) x1;
				3:	print " (que lleva puest", (o) x1;
				4:	print " (que llevaba puest", (o) x1;
				5:	print " (que llevabas puest", (o) x1;
				6:	print " (que llevaba puest", (o) x1;
				}
			11:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print " (que est", (n) x1;
				4,5,6:	print " (que estaba", (n) x1;
				}
			12:	print " abiert", (o) x1;
			13:	print " abiert", (o) x1, ", pero vac", (o) x1;
			14:	print " cerrad", (o) x1;
			15:	print " cerrad", (o) x1, " con llave";
			16:	print " vac", (o) x1;
			17:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print " (que est", (n) x1, " vac", (o) x1, ")";
				4,5,6:	print " (que estaba", (n) x1, " vac", (o) x1, ")";
				}
			18:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print " que contiene ";
				4,5,6:	print " que contena ";
				}
			19:	print " (sobre ", (el_) x1;
			20:	print ", encima ", (del_) x1;
			21:	print " (en ", (el_) x1;
			22:	print ", dentro ", (del_) x1;
		}
		return true;

	LMode1:
		!! Adems se ha reescrito tambin la rutina LMode1Sub de la lib.
		print_ret (stparser) "El relato est ahora en su modo ~breve~, que da 
		slo descripciones largas de los lugares la primera vez que son 
		visitados, y se limita a imprimir el nombre de la localidad en otro 
		caso.";

	LMode2:
		!! Adems se ha reescrito tambin la rutina LMode2Sub de la lib.
		print_ret (stparser) "El relato est ahora en su modo normal ~largo~, 
		que siempre da descripciones largas de los lugares (incluso si ya 
		habas estado antes).";

	LMode3:
		!! Adems se ha reescrito tambin la rutina LMode3Sub de la lib.
		print_ret (stparser) "El relato est ahora en su modo ~superbreve~, que 
		slo imprime el nombre de las localidades (incluso si nunca habas 
		estado antes).";

	Lock:
		!!	1:	Error, el objeto al que se intenta echar el cerrojo no tiene la 
		!!		propiedad "lockable".
		!!	2:	Error, el objeto al que se intenta echar el cerrojo tiene la 
		!!		propiedad "lockable", pero ya tiene tambin "locked".
		!!	3:	Error, el objeto tiene las propiedades "lockable" y "open". No 
		!!		se le puede echar el cerrojo hasta que no se cierre.
		!!	4:	Error, el <objeto2> especificado no coincide con el que el 
		!!		objeto indica en su propiedad "with_key".
		!!	5:	xito, se echa el cerrojo al objeto (con el <objeto2> si ste 
		!!		es especificado y se puede encontrar en la variable "second").
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No parece", (n) x1, " tener ningn tipo de cerrojo.";
				4,5,6:	"No pareca", (n) x1," tener ningn tipo de cerrojo.";
				}
			2:	if (x1 provides with_key)
					print_ret (The) x1, " ya estaba", (n) x1, 
					" cerrad", (o) x1, " con llave.";
				switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print_ret (The) x1, " ya tiene", (n) x1, 
						" echado el cerrojo.";
				4,5,6:	print_ret (The) x1, " ya tena", (n) x1,
						" echado el cerrojo.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	"Primero tendr que cerrar ", (the) x1, ".";
				2:	"Primero tendrs que cerrar ", (the) x1, ".";
				3:	"Primero tendr que cerrar ", (the) x1, ".";
				4:	"Primero tena que cerrar ", (the) x1, ".";
				5:	"Primero tenas que cerrar ", (the) x1, ".";
				6:	"Primero tena que cerrar ", (the) x1, ".";
				}
			4:	if (second) switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No parece", (n) x1, " encajar en la cerradura.";
				4,5,6:	"No pareca", (n) x1, " encajar en la cerradura.";
				}
				switch (GRAMMATICAL_FLEXION) {
				1:	print "Necesito ";
				2:	print "Necesitas ";
				3:	print "Necesita ";
				4:	print "Necesitaba ";
				5:	print "Necesitabas ";
				6:	print "Necesitaba ";
				} "algn tipo de llave.";
			5:	switch (GRAMMATICAL_FLEXION) {
				1:	if (~~second) "Echo el cerrojo ", (al) x1, ".";
					"Cierro ", (the) x1, " con ", (the) second, ".";
				2:	if (~~second) "Echas el cerrojo ", (al) x1, ".";
					"Cierras ", (the) x1, " con ", (the) second, ".";
				3:	if (~~second) "Echa el cerrojo ", (al) second, ".";
					"Cierra ", (the) x1, " con ", (the) second, ".";
				4:	if (~~second) "Ech el cerrojo ", (al) x1, ".";
					"Cerr ", (the) x1, " con ", (the) second, ".";
				5:	if (~~second) "Echaste el cerrojo ", (al) x1, ".";
					"Cerraste ", (the) x1, " con ", (the) second, ".";
				6:	if (~~second) "Ech el cerrojo ", (al) x1, ".";
					"Cerr ", (the) x1, " con ", (the) second, ".";
				}
		}

	Look: 
		!! La accin Look se genera cuando el jugador pone MIRAR, pero tambin 
		!! de forma automtica al entrar en una localidad nueva, o cuando el 
		!! jugador sale o se baja de un objeto en el que estaba.
		!!	1:	Aclaracin a aadir tras el ttulo si el jugador est 
		!!		subido en un objeto.
		!!	2:	Aclaracin a aadir tras el ttulo si el jugador est 
		!!		dentro de un objeto.
		!!	3:	Aclaracin a aadir tras el ttulo si el jugador ha sido 
		!!		transformado en otro personaje, mediante una llamada a 
		!!		ChangePlayer(nuevo,1) [sin el 1 la lib. no mostrar este msj.].
		!!	4:	Una vez que la librera ha mostrado la descripcin de la 
		!!		localidad, si el jugador estaba encima del soporte, la lib. 
		!!		generar este mensaje 4 para mostrar qu ms cosas hay sobre el 
		!!		objeto supporter.
		!! 5,6:	Son usados por la librera para listar los objetos "simples" 
		!!		que hay en la localidad. Son objetos "simples" los que no dan 
		!!		su propia auto-descripcin a travs de "describe" o "initial".
		!!	7:	Respuesta estndar para MirarHacia.
		switch( n ) {
			1:	print ", ";
				!! Se puede usar un mensaje de aclaracin completamente 
				!! personalizado definiendo la propiedad "clarification" en un 
				!! objeto ("clarification" tiene que devolver un string o una 
				!! rutina encargada de imprimir un string). Ej: SALA DE ESTAR, 
				!! sentado en el sof
				if ( x1 provides clarification && x1.clarification ~= 0 ) {
					if (x1.clarification ofclass string) 
						print (string) x1.clarification;
					else if (x1.clarification ofclass routine)
						indirect( x1.clarification);
				}
				else print "sobre ", (the) x1;
				return true;
			2:	print ", ";
				!! [ Ver comportamiento de Look con n == 1]
				if ( x1 provides clarification && x1.clarification ~= 0 ) {
					if (x1.clarification ofclass string) 
						print (string) x1.clarification;
					else if (x1.clarification ofclass routine)
						indirect( x1.clarification);
				}
				else print ", en ", (the) x1;
				return true;
			3:	print " (como ", (object) x1 , ")";
				return true;
			4:	print "^Sobre ", (the) x1;
				WriteListFrom( child(x1), 
					ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT
					+ TERSE_BIT + ISARE_BIT + CONCEAL_BIT);
				".";
			5,6:	
				new_line;
				if (x1~=location) {
					if (x1 has supporter) print "Sobre "; else print "En ";
					print (the) x1;
					switch (GRAMMATICAL_FLEXION) {
					1:	print " puedo ver ";
					2:	print " puedes ver ";
					3:	print " puede ver ";
					4:	print " poda ver ";
					5:	print " podas ver ";
					6:	print " poda ver ";
					}
				}
				else switch (GRAMMATICAL_FLEXION) {
				1:	print "Puedo ver ";
				2:	print "Puedes ver ";
				3:	print "Puede ver ";
				4:	print "Poda ver ";
				5:	print "Podas ver ";
				6:	print "Poda ver ";
				}
				if ( n == 5 ) print "tambin ";
				WriteListFrom( child(x1),
					ENGLISH_BIT + WORKFLAG_BIT + RECURSE_BIT
					+ PARTINV_BIT + TERSE_BIT + CONCEAL_BIT );
				if ( x1 ~= location ) ".";
				".";
			7:	switch (GRAMMATICAL_FLEXION) {
				1:	print "No observo";
				2:	print "No observas";
				3:	print "No observa";
				4:	print "No observ";
				5:	print "No observaste";
				6:	print "No observ";
				} " nada digno de mencin al mirar hacia ", (the) x1, ".";
			8:	if (x1 has supporter) print " (sobre ";
				else print " (en ";
				print (the) x1, ")";
				return true;
		}

	LookUnder:
		!!	1:	Error, estamos a oscuras.
		!!	2:	xito, mensaje por defecto.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"Est muy oscuro.";
				4,5,6:	"Estaba muy oscuro.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No veo nada interesante.";
				2:	"No ves nada interesante.";
				3:	"No ve nada interesante.";
				4:	"No vi nada interesante.";
				5:	"No viste nada interesante.";
				6:	"No vi nada interesante.";
				}
		}

	Mild:
		"Bastante.";

	Miscellany:
		!! Esta falsa accin se usa simplemente para agrupar todos los mensajes 
		!! de error del parser, los mensajes ante algunos metacomandos, o 
		!! algunos mensajes de la librera no relacionados con accin alguna.
		switch( n ) {
			1:
				! El jugador ha especificado objetos mltiples, pero el parser 
				! tiene una lista que no admite ms de 16.
				print_ret (stparser) "Slo se consideran los diecisis primeros 
				objetos.";
			2:
				! El jugador ha usado objetos mltiples, pero por alguna razn 
				! la lista del parser est vaca.
				print_ret (stparser) "No se sabe a qu objetos te refieres.";
			3:
				! Mensaje fin del relato. Has muerto.
				! print " Has muerto ";
				" Has muerto ";
			4:
				! Mensaje fin del relato. Victoria.
				! print " Has ganado ";
				" Has ganado ";
			5:
				! Mensaje a mostrar tras el fin del juego, para pedir al 
				! jugador si quiere reiniciar, recuperar, anular, puntuacin, 
				! curiosidades o terminar.
				print "^Quieres REINICIAR, RECUPERAR una lectura guardada";
				#Ifdef	DEATH_MENTION_UNDO;
				print ", ANULAR tu ltimo movimiento";
				#Endif;
				if (TASKS_PROVIDED == 0)
					print ", ver la PUNTUACIN obtenida durante el relato";
				if (deadflag==2 && AMUSING_PROVIDED==0)
					print ", ver algunas CURIOSIDADES";
				" o TERMINAR?";
			6:
				! Error si el intrprete no tiene "undo".
				print_ret (stparser) "Tu intrprete no puede ~deshacer~ 
				acciones.";
			7:
				! Otro error ocasionado ante una accin "undo".
				print_ret (stparser) "No puedes ~deshacer~ ms.";
			8:
				! Si el jugador no responde correctamente a la pregunta del 
				! mensaje [Miscellany, 5]
				"Por favor, da una de las respuestas anteriores.";
			9:
				! Mensaje cuando se detecta, al final del turno, que ya no hay 
				! una fuente de luz en la localidad actual.
				switch (GRAMMATICAL_FLEXION) {
				1:	"^Me he quedado a oscuras!";
				2:	"^Te has quedado a oscuras!";
				3:	"^Se ha quedado a oscuras!";
				4:	"^Me qued a oscuras!";
				5:	"^Te quedaste a oscuras!";
				6:	"^Se qued a oscuras!";
				}
			10:
				! Se introduce una lnea en blanco.
				<Look>; 
				InformLibrary.end_turn_sequence();
				return true;
			11:
				! Si el jugador intenta "undo" al principio del juego.
				print_ret (stparser) "No se puede ~deshacer~ lo que no has 
				hecho.";
			12:
				! Si el jugador intenta "undo" dos veces seguidas.
				print_ret (stparser) "No se pueden ~deshacer~ dos acciones 
				seguidas.";
			13:
				! xito en el "undo".
				print_ret (stparser) "Retrocediendo al turno anterior.";
			14:
				! Error al usar el comando EEPA.
				print_ret (stparser) "Eso no puede corregirse.";
			15:
				! Se usa EEPA sin especificar la palabra corregida.
				print_ret (stparser) "No te preocupes.";
			16:
				! Si el jugador pone EEPA seguido de dos o ms palabras.
				print_ret (stparser) "~Eepa~ slo puede corregir una palabra.";
			17:
				! Descripcin del objeto Oscuridad.
				switch (GRAMMATICAL_FLEXION) {
				1:	"Est muy oscuro y no puedo ver nada.";
				2:	"Est muy oscuro y no puedes ver nada.";
				3:	"Est muy oscuro y no puede ver nada.";
				4:	"Estaba muy oscuro y no poda ver nada.";
				5:	"Estaba muy oscuro y no podas ver nada.";
				6:	"Estaba muy oscuro y no poda ver nada.";
				}
			18:
				! Nombre corto del objeto jugador.
				switch (GRAMMATICAL_FLEXION) {
				1, 4:	print " mi mism", (o) player;
				2, 5:	print " ti mism", (o) player;
				3, 6:	print " si mism", (o) player;
				}
			19:
				! El PJ se examina a si mismo.
				if ( player.description ) return player.description();
				else <<Inv>>; 
			20:
				! Cuando el jugador pone PNJ, REPITE para que el PNJ 
				! haga otra vez la ltima accin.
				print_ret (stparser) "Para repetir un comando como ~rana, 
				salta~, escribe ~repite~ en lugar de ~rana, repite~.";
			21:
				! El jugador pone REPITE como primer comando del juego.
				print_ret (stparser) "No hay comando que repetir.";
			22:
				! El jugador ha comenzado la frase con una coma.
				print_ret (stparser) "No se puede empezar la frase con una 
				coma.";
			23:
				! El jugador intenta hablar con alguien no presente.
				print_ret (stparser) "No se pudo entender esa instruccin.";
			24:
				! Si el jugador intenta hablar con un objeto que no es 
				! "animate" ni "talkable" ("talkable" se reserva para ser usado 
				! con objeto inanimados con los que se podra intentar hablar, 
				! como por ejemplo un micrfono).
				print_ret (stparser) "No puedes hablar con ", (the) x1, ".";
			25:
				! Hay palabras no comprendidas entre el nombre de un PNJ y la 
				! coma, ej: PEPE ZAFDSRGG, SALTA.
				print_ret (stparser) "Para iniciar una conversacin, usa 
				simplemente la orden HABLA (a/con) PERSONAJE.";
			26:
				! La gramtica especifica que una accin debe efectuarse sobre 
				! un objeto en poder del jugador (token 'held'), pero el 
				! jugador lo ha intentado sobre un objeto que no tiene, aunque 
				! est a su alcance. El parser intentar automticamente coger 
				! ese objeto antes de efectuar la accin. En este mensaje se 
				! avisa al jugador de esta intencin.
				switch (GRAMMATICAL_FLEXION) {
				1:	"(Primero trato de ", (coge)"r ", (the) x1, ".)";
				2:	"(Primero tratas de ", (coge)"r ", (the) x1, ".)";
				3:	"(Primero trata de ", (coge)"r ", (the) x1, ".)";
				4:	"(Primero trat de ", (coge)"r ", (the) x1, ".)";
				5:	"(Primero trataste de ", (coge)"r ", (the) x1, ".)";
				6:	"(Primero trat de ", (coge)"r ", (the) x1, ".)";
				}

			! 27:	! manejado por ParserError.
			! 28:	! manejado por ParserError.
			! 29:	! manejado por ParserError.
			! 30:	! manejado por ParserError.
			! 31:	! manejado por ParserError.
			! 32:	! manejado por ParserError.
			! 33:	! manejado por ParserError.
			! 34:	! manejado por ParserError.
			! 35:	! manejado por ParserError.
			! 36:	! manejado por ParserError.
			! 37:	! manejado por ParserError.
			! 38:	! manejado por ParserError.
			! 39:	! manejado por ParserError.
			! 40:	! manejado por ParserError.
			! 41:	! manejado por ParserError.
			! 42:	! manejado por ParserError.
			! 43:	! manejado por ParserError.

			44:
				! El jugador ha intentado objetos mltiples usando TODO, pero 
				! el parser no ha encontrado ninguno. Por ejemplo, COGE TODO si 
				! no hay nada cerca o en el inventario.
				if (action_to_be == ##Drop) {
					switch (GRAMMATICAL_FLEXION) {
					1:	print "Pero si no llevo nada";
						if ( children(player) ) " de eso!";
						else "!";
					2:	print "Pero si no llevas nada";
						if ( children(player) ) " de eso!";
						else "!";
					3:	print "Pero si no lleva nada";
						if ( children(player) ) " de eso!";
						else "!";
					4:	print "Pero si no llevaba nada";
						if ( children(player) ) " de eso!";
						else "!";
					5:	print "Pero si no llevabas nada";
						if ( children(player) ) " de eso!";
						else "!";
					6:	print "Pero si no llevaba nada";
						if ( children(player) ) " de eso!";
						else "!";
					}
				}
				switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print "No hay nada para ";
				4,5,6:	print "No haba nada para ";
				}
				LanguageVerb( verb_word );
				".";
			45:
				! Desambiguacin de PNJs.
				print "Quin concretamente, ";
				PreguntaCualExactamente=1;
				ImprimirListaDudosos( "o" );
				return true;
			46:
!! PROBAR.
				! Desambiguacin de objetos.
				print "Cul concretamente, ";
				PreguntaCualExactamente=1;
				ImprimirListaDudosos( "o" );
			47:
				! El jugador ha respondido "TODOS" o "AMBOS" a una pregunta 
				! aclaratoria como la [Miscellany,46], pero el verbo no admite 
				! objetos mltiples.
				st_parser();
				if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
				print "Lo siento, slo puedes referirte a un objeto aqu. 
				Cul exactamente?";
				if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2;
				st_normal();
				new_line;
				PreguntaCualExactamente=1;
			48:
				! El jugador ha escrito una frase y orden a PSI incompleta.
				st_parser();
				if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
				PreguntaCualExactamente = 1;
				print "Tienes que indicar a quin";
				if ( actor ~= player ) print " tiene que ";
				else print " quieres ";
				IdiomaImprimirComando();
				print ".";
				if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2;
				st_normal();
				new_line;
				return true;
			49:
				! El jugador ha escrito una frase u orden incompleta.
				print_ret (stparser) "Tienes que indicar qu, con qu o dnde 
				quieres hacer eso.";
!! PROBAR.
			50:
				! El jugador acaba de realizar una accin que punta.
				print "Tu puntuacin ha ";
				if (x1 > 0) print "aumentado";
				else { x1 = -x1; print "disminudo"; }
				print " en ", (number) x1, " punto";
				if (x1 > 1) print "s";
				!return true;
			51:
				! El jugador ha intentado una accin con objeto mltiple 
				! (como COGE TODO). Esta accin es convertida por el parser en 
				! una serie de acciones (COGE OBJ1, COGE OBJ2, etc...) Si en la 
				! ejecucin de alguna de estas acciones se encuentra que la 
				! localidad del jugador ha cambiado, se aborta el proceso. Este 
				! mensaje informa de ello al jugador.
				print_ret (stparser) "Ya que ha ocurrido algo dramtico, se ha 
				recortado la lista de objetos sobre los que actuabas.";
			52:
				! En los mens [...].
				"^Escribe un nmero del 1 al ", x1,
				", 0 para volver a mostrarlo, o pulsa Intro.";
			53:
				! En los mens [...].
				"^[Por favor, pulsa ESPACIO]";
			54:
				print_ret (stparser) "Comentario guardado.";
			55:
				print_ret (stparser) "Comentario NO guardado.";
			56:	print ".^";
			57:	print "?^";
		}

	No:
		!! Cuando el jugador pone NO, a secas, se genera esta accin. Est 
		!! pensada por si el relato suelta una frase del estilo de "Pero t 
		!! eres tonto?" y el jugador responde NO. De todas formas, hay un 
		!! problema, y es que NO es normalmente la accin Ir al noroeste. Si 
		!! queremos que NO sea provisionalmente la accin No, entonces se debe 
		!! poner a 1 la variable PreguntaSiNo antes de escribir el texto 
		!! "Pero t eres tonto?". En ese caso, el parser interpretar "NO" 
		!! como la accin No, pero nicamente durante el siguiente turno.
		"Slo era una pregunta retrica.";

	NotifyOff:
		print_ret (stparser) "Notificacin de puntuacin desactivada.";

	Objects:
		!! Ante el verbo "OBJETOS" se genera esta accin, que muestra una 
		!! lista de todos los objetos que el jugador ha manipulado a lo largo 
		!! del juego, junto la indicacin de lo que ha hecho con ellos.
		switch (n) {
			1:	"Objetos que has manejado:^";
			2:	"Ninguno.";
			3:	print "   (puesto)";
			4:	print "   (contigo)";
			5:	print "   (dejado con alguien)";
			6:	print "   (ahora en ", (name) x1, ")";
			7:	print "   (ahora en ", (the) x1, ")";
			8:	print "   (ahora dentro ", (del) x1, ")";
			9:	print "   (ahora en ", (the) x1, ")";
			10:	print "   (perdido)";
		}

	Open:
		!!	1:	Error, el objeto no tiene el atributo "openable".
		!!	2:	Error, el objeto es abrible, pero tiene "locked".
		!!	3:	Error, el objeto es abrible, pero ya tiene el atributo "open".
		!!	4:	xito, el objeto se abre, y adems era recipiente. Se muestra 
		!!		entoces la lista de objetos que haba en su interior (si habia 
		!!		algo).
		!!	5:	xito, el objeto se abre (pero no tiene nada en su
		!!		interior, o no era recipiente).
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No es algo que pueda abrirse.";
				4,5,6:	"No era algo que se pudiese abrir.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"Est", (n) x1, " cerrad", (o) x1, " con llave.";
				4,5,6:	"Estaba", (n) x1, " cerrad", (o) x1, " con llave.";
				}
			3:	"Ya estaba", (n) x1, " abiert", (o) x1, ".";
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Abro ";	2: print "Abres ";		3:	print "Abre ";
				4:	print "Abr ";	5: print "Abriste ";	6:	print "Abri ";
				}
				print (the) x1, ", descubriendo ";
				if (WriteListFrom(child(x1),
					ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT)==0) "nada.";
				".";
			5:	switch (GRAMMATICAL_FLEXION) {
				1:	"Abro ", (the) x1, ".";
				2:	"Abres ", (the) x1, ".";
				3:	"Abre ", (the) x1, ".";
				4:	"Abr ", (the) x1, ".";
				5:	"Abriste ", (the) x1, ".";
				6:	"Abri ", (the) x1, ".";
				}
		}

!	Order:	mira Answer.

	Places:
		!! El verbo "LUGARES" muestra un listado de los lugares que el jugador 
		!! ha visitado a lo largo del relato.
		switch (n) {
			1:	print "Has visitado: ";
			2:	print ".^";
		}

	Pray:
!		switch (GRAMMATICAL_FLEXION) {
!		1,2,3:	"Rezar no servir de nada aqu.";
!		4,5,6:	"Rezar no hubiese servido de nada.";
!		}
		"Se pregunt si Dios y si su abuela la estaran mirando en aquel 
		momento, all arriba, en el cielo. ---Oh, abuelita... cunto te 
		echo de menos!";

	Prompt:
		!! El prompt aparece justo antes de pedir una nueva lnea al jugador. 
		new_line;
		print (stcursiva) "> ";
		return true;

	Pronouns:
		!! Esta accin (generada por el verbo PRONOMBRES) muestra una lista 
		!! de qu significa en ese momento para el parser cada pronombre 
		!! -lo, -la, -los, -las...
		switch (n) {
			1:	st_parser();
				if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
				print "En este momento, ";
			2:	print "es ";
			3:	print "no est definido";
			4:	print "el juego no conoce ningn pronombre.";
				if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2;
				st_normal();
				new_line;
				return true;
			5:	print ".";
				if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2;
				st_normal();
				new_line;
				return true;
		}

	Pull, Push, Turn:
		!!	1:	El objeto tiene el atributo 'static'.
		!!	2:	El objeto tiene el atributo 'scenery'.
		!!	3:	El objeto no es 'static' ni 'scenery'.
		!!	4:	El objeto es un ser animado.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print "Est", (n) x1;
				4,5,6:	print "Estaba", (n) x1;
				} " firmemente sujet", (o) x1, ".";
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No soy capaz.";
				2:	"No eres capaz.";
				3:	"No es capaz.";
				4:	"No fui capaz.";
				5:	"No fuiste capaz.";
				6:	"No fue capaz.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No ocurre nada, aparentemente.";
				4,5,6:	"No ocurri nada, aparentemente.";
				}
			4:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"Eso sera, como poco, maleducado.";
				4,5,6:	"Eso hubiese sido, como poco, maleducado.";
				}
		}

!	Push:	mira Pull.

	PushDir:
		!!	1:	Si el juego no ha previsto la posibilidad de empujar ese
		!!		objeto hacia una direccin (o sea, no llama a la rutina
		!!		PermitirEmujarDir). Esta es la respuesta por defecto ms
		!!		habitual.
		!!	2:	Si el jugador pone tras HACIA algo que no es una direccin.
		!!		(respuesta por defecto en este caso).
		!!	3:	Si intenta empujar hacia arriba o hacia abajo.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No creo que empujar ", (the) x1, " sirva de nada.";
				4,5,6:	"No creo que empujar ", (the) x1, " hubiese servido 
						de nada.";
				}
			2:	"Eso no es una direccin.";
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	print "No, no puedo";
				2:	print "No, no puedes";
				3:	print "No, no puede";
				4:	print "No, no poda";
				5:	print "No, no podas";
				6:	print "No, no poda";
				} " empujar", (lo) x1, " en esa direccin.";
		}

	PutOn:
		!!	1:	Error, el objeto no est en poder del jugador. [Nota, conviene 
		!!		mirar en este caso si el objeto es animado o no, para generar 
		!!		un mensaje ms adecuado].
		!!	2:	Error, el jugador intenta poner un objeto sobre s mismo.
		!!	3:	Error, el jugador intenta poner el objeto sobre otro que no
		!!		tiene el atributo "supporter".
		!!	4:	Error, el jugador intenta poner un objeto sobre el propio
		!!		jugador.
		!!	5:	Aviso, el objeto es una prenda puesta. La librera va a
		!!		quitrselo automticamente antes de reintentar la accin PutOn.
		!!	6:	Error, se intenta poner el objeto sobre otro en el que ya no
		!!		queda sitio (el nmero de objetos que caben en el soporte se
		!!		indica en su propiedad "capacity").
		!!	7:	Exito. Mensaje a mostrar para cada objeto puesto cuando se
		!!		ponen muchos (ej: PON TODO SOBRE LA MESA).
		!!	8:	Exito. Mensaje a mostrar cuando se pone un objeto sobre otro.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	if (x1 has animate)
						"Antes tendra que ", (coge)"rl", (o) x1, " y no s 
						si se dejar", (n) x1, ".";
					else
						"Necesito tener ", (the) x1, " para poder poner", 
						(lo) x1, " donde sea.";
				2:	if (x1 has animate)
						"Antes tendras que ", (coge)"rl", (o) x1, " y no s 
						si se dejar", (n) x1, ".";
					else
						"Necesitas tener ", (the) x1, " para poder poner", 
						(lo) x1, " donde sea.";
				3:	if (x1 has animate)
						"Antes tendra que ", (coge)"rl", (o) x1, " y no s 
						si se dejar", (n) x1, ".";
					else
						"Necesita tener ", (the) x1, " para poder poner", 
						(lo) x1, " donde sea.";
				4:	if (x1 has animate)
						"Antes tendra que haber", (lo) x1, " cogido, y no 
						creo que ", (the) x1, " se hubiese", (n) x1, 
						" dejado.";
					else
						"Hubiese necesitado tener ", (the) x1, " para poder 
						poner", (lo) x1, " donde fuese.";
				5:	if (x1 has animate)
						"Antes tendras que haber", (lo) x1, " cogido, y no 
						creo que ", (the) x1, " se hubiese", (n) x1, 
						" dejado.";
					else
						"Hubieses necesitado tener ", (the) x1, " para poder 
						poner", (lo) x1, " donde fuese.";
				6:	if (x1 has animate)
						"Antes tendra que haber", (lo) x1, " cogido, y no 
						creo que ", (the) x1, " se hubiese", (n) x1, 
						" dejado.";
					else
						"Hubiese necesitado tener ", (the) x1, " para poder 
						poner", (lo) x1, " donde fuese.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	print "No puedo poner ";
				2:	print "No puedes poner ";
				3:	print "No puede poner ";
				4:	print "No poda poner ";
				5:	print "No podas poner ";
				6:	print "No poda poner ";
				} "un objeto sobre s mismo.";
			3:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"Poner cosas sobre ", (the) x1," no servir de nada.";
				4,5,6:	"Poner cosas sobre ", (the) x1, " no hubiese servido 
						de nada.";
				}
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	"No s hacer equilibrios.";
				2:	"No sabes hacer equilibrios.";
				3:	"No sabe hacer equilibrios.";
				4:	"No saba hacer equilibrios.";
				5:	"No sabas hacer equilibrios.";
				6:	"No saba hacer equilibrios.";
				}
			5:	switch (GRAMMATICAL_FLEXION) {
				1:	"(Primero me ", (lo) x1, " quito.)^";
				2:	"(Primero te ", (lo) x1, " quitas.)^";
				3:	"(Primero se ", (lo) x1, " quita.)^";
				4:	"(Primero me ", (lo) x1, " quit.)^";
				5:	"(Primero te ", (lo) x1, " quitaste.)^";
				6:	"(Primero se ", (lo) x1, " quit.)^";
				}
			6:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print "No queda sitio ";
				4,5,6:	print "No quedaba sitio ";
				} "en ", (the) x1, " para poner nada ms.";
			7:	"Hecho.";
			8:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Coloco ";
				2:	print "Colocas ";
				3:	print "Coloca ";
				4:	print "Coloqu ";
				5:	print "Colocaste ";
				6:	print "Coloc ";
				} print_ret (the) x1, " sobre ", (the) second, ".";
		}

	Quit:
		switch (n) {
			1:	print (stparser) "Por favor, responde s o no.", " ";
			2:	print (stparser) "Realmente quieres abandonar el cuento?", " ";
		}
		return true;

	Remove:
		!!	1:	El recipiente que contiene el objeto que el jugador quiere
		!!		sacar, est cerrado. (x1 apunta al objeto, no al recipiente, 
		!!		el cul puede obtenerse con parent(x1)).
		!!	2:	El objeto no est dentro del recipiente que el jugador ha dicho.
		!!	3:	xito.
		switch (n) {
			1:	print "Por desgracia ", (the) parent( x1 );
				switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print " est", (n) parent( x1 );
				4,5,6:	print " estaba", (n) parent( x1 );
				}	" cerrad", (o) parent( x1 ), ".";
			2:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	if (second has animate) 
							"Pero si no ", (lo) x1, " tiene", (n) second,"!";
						"Pero si no est", (n) x1, " ah ahora!";
				4,5,6:	if (second has animate)
							"Pero si no ", (lo) x1, " tena", (n) second,"!";
						"Pero si no estaba", (n) x1, " ah!";
				}
			3:	if (verb_word == 'quita') "Quitad", (o) x1, ".";
				"Sacad", (o) x1, ".";
		}

	Restart:
		switch (n) {
			1:	print (stparser) "Realmente quieres reiniciar el cuento?", " ";
			2:	print (stparser) "Error al reiniciar.^";
		}
		return true;

	Restore:
		switch (n) {
			1:	print_ret (stparser) "Error. No se pudo recuperar la partida.";
			2:	print (stparser) "Partida cargada."; 
				new_line;
				<<Look>>; 
		}

	Rub:
		switch (GRAMMATICAL_FLEXION) {
		1,2,3:	"Ya ", (esta) x1, " bastante limpi", (o) x1, ".";
		4,5,6:	"Ya estaba", (n) x1, " bastante limpi", (o) x1, ".";
		}

	Save:
		switch (n) {
			1:	print_ret (stparser) "Error. No se pudo guardar la partida.";
			2:	print_ret (stparser) "Partida guardada.";
		}

!! PROBAR.
	Score:
		!! Puntuacin. Puede activarse porque el jugador lo solicita (usando el 
		!! verbo "PUNTUACIN") o porque el relato ha terminado.
		switch (n) {
			1:	if (deadflag) print "En este relato, tu puntuacin ha sido ";
				else print "Hasta el momento tu puntuacin es ";
				print score, " de un total de ", MAX_SCORE,
				", en ", turns, " turno";
				if (turns>1) print "s"; ".";
			2:	print_ret (stparser) "Este relato no tiene conteo de 
				puntuacin.";
		}

	ScriptOff:
		switch (n) {
			1:	print_ret (stparser) "La transcripcin ya estaba desactivada.";
			2:	new_line; print_ret (stparser) "Fin de la transcripcin.";
			3:	print_ret (stparser) "Intento fallido de finalizacin de 
				transcripcin.";
		}

	ScriptOn:
		switch (n) {
			1:	print_ret (stparser) "La transcripcin ya estaba activada.";
			2:	print_ret (stparser) "Iniciando la transcripcin de:";
			3:	print_ret (stparser) "Intento fallido al comienzo de la 
				transcripcin.";
		}

	Search:
		!!	1:	Error, estamos a oscuras.
		!!	2:	xito examinando soporte, pero no hay nada sobre l.
		!!	3:	xito examinando soporte, listar lo que hay.
		!!	4:	El objeto examinado no es soporte ni recipiente, mensaje
		!!		estndar indicando que no se encuentra nada.
		!!	5:	Error, El objeto examinado es recipiente, pero est cerrado.
		!!	6:	xito, el objeto examinado es recipiente abierto, pero no
		!!		tiene nada dentro.
		!!	7:	xito, el objeto examinado es recipiente abierto y tiene
		!!		cosas dentro. Se las lista.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"Est muy oscuro.";
				4,5,6:	"Estaba muy oscuro.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print "No hay ";
				4,5,6:	print "No haba ";
				} "nada sobre ", (the) x1, ".";
			3:	print "Sobre ", (the) x1;
				WriteListFrom( child(x1), 
					TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
				".";
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	"No encuentro nada interesante.";
				2:	"No encuentras nada interesante.";
				3:	"No encuentra nada interesante.";
				4:	"No encontr nada interesante.";
				5:	"No encontraste nada interesante.";
				6:	"No encontr nada interesante.";
				}
			5:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo ver lo que hay dentro ", (del) x1, " porque 
					est", (n) x1, " cerrad", (o) x1, ".";
				2:	"No puedes ver lo que hay dentro ", (del) x1, " porque 
					est", (n) x1, " cerrad", (o) x1, ".";
				3:	"No puede ver lo que hay dentro ", (del) x1, " porque 
					est", (n) x1, " cerrad", (o) x1, ".";
				4:	"No poda ver lo que hay dentro ", (del) x1, " porque 
					estaba", (n) x1, " cerrad", (o) x1, ".";
				5:	"No podas ver lo que hay dentro ", (del) x1, " porque 
					estaba", (n) x1, " cerrad", (o) x1, ".";
				6:	"No poda ver lo que hay dentro ", (del) x1, " porque 
					estaba", (n) x1, " cerrad", (o) x1, ".";
				}
			6:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print_ret (The) x1, " est", (n) x1, 
						" vac", (o) x1, ".";
				4,5,6:	print_ret (The) x1, " estaba", (n) x1,
						" vac", (o) x1, ".";
				}
			7:	print "En ", (the) x1;
				WriteListFrom( child(x1),
					TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
				".";
		}

	Set:
		switch (GRAMMATICAL_FLEXION) {
		1:	"No puedo hacerlo.";
		2:	"No puedes hacerlo.";
		3:	"No puede hacerlo.";
		4:	"No poda hacerlo.";
		5:	"No podras hacerlo.";
		6:	"No poda hacerlo.";
		}

	SetTo:
		switch (GRAMMATICAL_FLEXION) {
		1,2,3:	"Eso no puede regularse a ningn valor.";
		4,5,6:	"Eso no poda regularse a ningn valor.";
		}

	Show:
		!!	1:	Error, el jugador intenta mostrar un objeto que no tiene.
		!!	2:	Aviso, se ha enviado la accin Show al PNJ, pero este no ha 
		!!		respondido. En este caso x1 apunta al PNJ y no al objeto que 
		!!		le hemos mostrado.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"No tengo ", (the) x1, ".";
				2:	"No tienes ", (the) x1, ".";
				3:	"No tiene ", (the) x1, ".";
				4:	"No tena ", (the) x1, ".";
				5:	"No tenas ", (the) x1, ".";
				6:	"No tena ", (the) x1, ".";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print_ret (The) x1, " no muestra", (n) x1, 
						" ningn inters.";
				4,5,6:	print_ret (The) x1, " no mostraba", (n) x1,
						" ningn inters.";
				}
		}

	Sing:
!		switch (GRAMMATICAL_FLEXION) {
!		1:	"Nunca he cantado bien.";
!		2:	"Nunca has cantado bien.";
!		3:	"Nunca ha cantado bien.";
!		4:	"Nunca supe cantar bien.";
!		5:	"Nunca supiste cantar bien.";
!		6:	"Nunca supo cantar bien.";
!		}
		"No tena nimos para cantar nada en aquel momento.";

	Sleep:
		switch (GRAMMATICAL_FLEXION) {
		1:	"An no tengo tanto sueo.";
		2:	"An no tienes tanto sueo.";
		3:	"An no tiene tanto sueo.";
		4:	"An no tena tanto sueo.";
		5:	"An no tenas tanto sueo.";
		6:	"An no tena tanto sueo.";
		}

	Smell:
		switch (GRAMMATICAL_FLEXION) {
		1:	"No huelo nada extrao.";
		2:	"No hueles nada extrao.";
		3:	"No huele nada extrao.";
		4,5,6:	"No ola a nada extrao.";
		}

	Sorry:
		print_ret (stparser) "No es necesario que te disculpes.";

	Squeeze:
		!!	1:	Tratar de retorcer un ser animado.
		!!	2:	Tratar de retorcer cualquier otro objeto.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"No creo que deba.";
				2:	"No creo que debas.";
				3:	"No creo que deba.";
				4:	"No se me hubiese ocurrido hacer algo as.";
				5:	"No se te hubiese ocurrido hacer algo as.";
				6:	"No se le hubiese ocurrido hacer algo as.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No consigo nada haciendo eso.";
				2:	"No consigues nada haciendo eso.";
				3:	"No consigue nada haciendo eso.";
				4:	"No consegu nada haciendo eso.";
				5:	"No conseguiste nada haciendo eso.";
				6:	"No consigui nada haciendo eso.";
				}
		}

	Strong:
!		print_ret (stparser) "No vas a conseguir nada ponindote hosco.";
		print_ret (stparser) "Se supone que esto es un cuento infantil! Por 
		favor, no uses ese vocabulario.";

	Swim:
		switch (GRAMMATICAL_FLEXION) {
		1:	"Nunca aprend a nadar.";
		2:	"Nunca aprendiste a nadar.";
		3:	"Nunca aprendi a nadar.";
		4:	"Nunca supe nadar.";
		5:	"Nunca supiste nadar.";
		6:	"Nunca supo nadar.";
		}

	Swing:
!! REVISAR
		switch (GRAMMATICAL_FLEXION) {
		1,2,3:	print "No parece", (n) x1, " muy adecuad", (o) x1, " para 
				columpiarse en "; SpanishNominativePronoun( x1 ); ".";
		4,5,6:	print "No pareca", (n) x1, " muy adecuad", (o) x1, " para 
				columpiarse en "; SpanishNominativePronoun( x1 ); ".";
		}

	SwitchOff:
		!!	1:	Error, el objeto no tiene el atributo "switchable".
		!!	2:	Error, el objeto ya tenia desactivado el atributo "on".
		!!	3:	xito, el objeto tiene ahora desactivado "on".
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No es algo que pueda apagarse.";
				4,5,6:	"No era algo que se pudiese apagar.";
				}
			2:	"Ya estaba", (n) x1, " apagad", (o) x1, ".";
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	"Apago ", (the) x1, ".";
				2:	"Apagas ", (the) x1, ".";
				3:	"Apaga ", (the) x1, ".";
				4:	"Apagu ", (the) x1, ".";
				5:	"Apagaste ", (the) x1, ".";
				6:	"Apag ", (the) x1, ".";
				}
		}

	SwitchOn:
		!!	1:	Error, el objeto no es conmutable (este error no aparecer
		!!		si el jugador pone ENCIENDE OBJETO, ya que en este caso la
		!!		accin generada ser Quemar objeto, pero puede aparecer si
		!!		pone CONECTA OBJETO).
		!!	2:	Error, el objeto ya tena el atributo "on".
		!!	3:	xito, el objeto tiene ahora activado "on".
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No es algo que pueda encenderse.";
				3,4,5:	"No era algo que se pudiese encender.";
				}
	    	2:	"Ya estaba", (n) x1, " encendid", (o) x1, ".";
	    	3:	switch (GRAMMATICAL_FLEXION) {
				1:	"Enciendo ", (the) x1, ".";
				2:	"Enciendes ", (the) x1, ".";
				3:	"Enciende ", (the) x1, ".";
				4:	"Encend ", (the) x1, ".";
				5:	"Encendiste ", (the) x1, ".";
				6:	"Encendi ", (the) x1, ".";
				}
		}
    
	Take:
		!!	1:	xito.
		!!	2:	Error, el objeto cogido es el propio jugador.
		!!	3:	Error, el objeto cogido es un objeto animado.
		!!	4:	Error, el jugador est subido o metido en el objeto que intenta 
		!!		coger.
		!!	5:	Error, el jugador ya tena ese objeto en su inventario.
		!!	6:	Error, el objeto est en poder de un ser animado [x1 apunta 
		!!		al ser, no al objeto, el cual puede obtenerse en la variable 
		!!		"noun"].
		!!	7:	Error, el objeto es un sub-objeto de otro (est dentro de un
		!!		objeto que tiene el atributo "transparent", pero no tiene el
		!!		atributo "container" ni "supporter").
		!!	8:	Error, el objeto est dentro de otro, pero este otro no tiene 
		!!		el atributo "container" ni "supporter" ni "transparent" 
		!!		(probablemente un error de programacin).
		!!	9:	Error, el objeto est dentro de un recipiente cerrado.
		!!	10:	Error, el objeto tiene el atributo "scenery".
		!!	11:	Error, el objeto tiene el atributo "static".
		!!	12:	Error, el jugador lleva demasiados objetos.
		!!	13: Mensaje de aviso, la librera ha decidido mover objetos del
		!!		inventario al "objeto saco" para hacer sitio y que el jugador
		!!		pueda coger el objeto. [El objeto saco es uno que puede
		!!		declarar el programador. Si el jugador lo coge y lo lleva
		!!		consigo, la librera lo usar automticamente como mochila
		!!		para descargar al jugador cuando sea necesario].
		switch (n) {
			1:	if (dialecto_sudamericano) print "Tomad"; else print "Cogid";
				print_ret (o) noun, ".";
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"Siempre me tengo a m mism", (o) player, ".";
				2:	"Siempre te tienes a t mism", (o) player, ".";
				3:	"Siempre se tiene a s mism", (o) player, ".";
				4:	"Siempre me he tenido a m mism", (o) player, ".";
				5:	"Siempre te has tenido a t mism", (o) player, ".";
				6:	"Siempre se ha tenido a s mism", (o) player, ".";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No creo que ", (al) x1, " le", (s) x1, " gustara.";
				4,5,6:	"No creo que ", (al) x1, " le", (s) x1, " hubiese 
						gustado.";
				}
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Tengo que ";
					if (x1 has supporter) print "bajarme "; 
					else print "salir ";
				2:	print "Tienes que ";
					if (x1 has supporter) print "bajarte ";
					else print "salir ";
				3:	print "Tiene que ";
					if (x1 has supporter) print "bajarse "; 
					else print "salir ";
				4:	print "Tena que ";
					if (x1 has supporter) print "bajarme ";
					else print "salir ";
				5:	print "Tenas que ";
					if (x1 has supporter) print "bajarte ";
					else print "salir ";
				6:	print "Tena que ";
					if (x1 has supporter) print "bajarse ";
					else print "salir ";
				}
				print_ret (del) x1, " antes.";
			5:	switch (GRAMMATICAL_FLEXION) {
				1:	"Ya tengo ", (the) x1, ".";
				2:	"Ya tienes ", (the) x1, ".";
				3:	"Ya tiene ", (the) x1, ".";
				4:	"Ya tena ", (the) x1, ".";
				5:	"Ya tenas ", (the) x1, ".";
				6:	"Ya tena ", (the) x1, ".";
				}
			6:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"Parece que pertenece", (n) noun, " ", (al) x1, ".";
				4,5,6:	"Parece que perteneca", (n) noun, " ", (al) x1, ".";
				}
			7:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"Parece", (n) noun, " formar parte ", (del) x1, ".";
				4,5,6:	"Pareca", (n) noun, " formar parte ", (del) x1, ".";
				}
			8:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No est", (n) x1, " disponible", (s) x1, ".";
				4,5,6:	"No estaba", (n) x1, " disponible", (s) x1, ".";
				}
			9:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print (The) x1, " no est", (n) x1;
				4,5,6:	print (The) x1, " no estaba", (n) x1;
				} " abiert", (o) x1, ".";
			10:	switch (GRAMMATICAL_FLEXION) {
				1:	"Difcilmente podra llevarme eso.";
				2:	"Difcilmente podras llevarte eso.";
				3:	"Difcilmente podra llevarse eso.";
				4:	"Difcilmente hubiese podido llevarme eso.";
				5:	"Difcilmente hubieses podido llevarte eso.";
				6:	"Difcilmente hubiese podido llevarse eso.";
				}
			11:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	print (The) x1, " est", (n) x1;
				4,5,6:	print (The) x1, " estaba", (n) x1;
				} " fij", (o) x1, " en el sitio.";
			12:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Ya tengo";
				2:	print "Ya tienes";
				3:	print "Ya tiene";
				4:	print "Ya tena";
				5:	print "Ya tenas";
				6:	print "Ya tena";
				} " las manos ocupadas con demasiadas cosas.";
			13:	switch (GRAMMATICAL_FLEXION) {
				1:	print "Primero introduzco ";
				2:	print "Primero introduces ";
				3:	print "Primero introduce ";
				4:	print "Primero introduje ";
				5:	print "Primero introdujiste ";
				6:	print "Primero introdujo ";
				}
				print_ret (the) x1 ," en uno de los bolsillos del abrigo 
				para hacer sitio.^";
	}

	Taste:
		switch (GRAMMATICAL_FLEXION) {
		1:	"No saboreo nada inesperado.";
		2:	"No saboreas nada inesperado.";
		3:	"No saborea nada inesperado.";
		4:	"No sabore nada inesperado.";
		5:	"No saboreaste nada inesperado.";
		6:	"No sabore nada inesperado.";
		}

!	Tell:	mira Answer.

	Think:
		"Buena idea.";

	ThrowAt:
		!!  1:	Lanzar cosas a objetos inanimados
		!!	2:	Lanzar cosas a objetos animados
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No servira de nada.";
				3,4,5:	"No hubiese servido de nada.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"En el ltimo momento me echo atrs.";
				2:	"En el ltimo momento te echas atrs.";
				3:	"En el ltimo momento se echa atrs.";
				4:	"En el ltimo momento me ech atrs.";
				5:	"En el ltimo momento te echaste atrs.";
				6:	"En el ltimo momento se ech atrs.";
				}
		}

!	Tie:	mira JumpOver.

	Touch:
		!!	1:	Si se intenta tocar a un ser animado
		!!	2:	Tocar un objeto normal del juego
		!!	3:	Tocarse a si mismo
		switch (n) {
			1: switch (GRAMMATICAL_FLEXION) {
				1:	"No creo que deba.";
				2:	"No creo que debas.";
				3:	"No creo que deba.";
				4:	"No creo que hubiese intentado hacer algo as.";
				5:	"No creo que hubieses intentado hacer algo as.";
				6:	"No creo que hubiese intentado hacer algo as.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No noto nada extrao al tacto.";
				2:	"No notas nada extrao al tacto.";
				3:	"No nota nada extrao al tacto.";
				4:	"No not nada extrao al tacto.";
				5:	"No notaste nada extrao al tacto.";
				6:	"No not nada extrao al tacto.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	"No creo que eso sirva de algo...";
				2:	"Si crees que eso servir de algo...";
				3:	"No creo que eso sirva de algo...";
				4,5,6: "No creo que algo as hubiese servido de nada.";
				}
		}

!	Turn:	mira Pull.

	Unlock:
		!!	1:	Error, el objeto que se intenta abrir, no tiene el atributo
		!!		"lockable".
		!!	2:	Error, el objeto que se intenta abrir tiene atributo
		!!		"lockable", pero no tiene atributo "locked".
		!!	3:	Error, el <objeto2> que se intenta usar como llave, no
		!!		coincide con la propiedad "with_key" del <objeto> que
		!!		intenta ser abierto.
		!!	4:	xito. El <objeto> se abre (con <objeto2> si ste ha sido
		!!		especificado, el cual podemos encontrarlo en la variable 
		!!		"second".
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No parece", (n) x1, " tener ningn tipo de cerrojo.";
				4,5,6:	"No pareca", (n) x1," tener ningn tipo de cerrojo.";
				}
			2:	print_ret (The) x1, " ya tena", (n) x1, " abierto el 
				cerrojo.";
			3:	if (second) switch (GRAMMATICAL_FLEXION) {
				1,2,3:	"No parece", (n) x1, " encajar en la cerradura.";
				4,5,6:	"No pareca", (n) x1, " encajar en la cerradura.";
				}
				switch (GRAMMATICAL_FLEXION) {
				1:	print "Necesito ";
				2:	print "Necesitas ";
				3:	print "Necesita ";
				4:	print "Necesitaba ";
				5:	print "Necesitabas ";
				6:	print "Necesitaba ";
				} "algn tipo de llave.";
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	if (~~second) "Quito el cerrojo ", (al) x1, ".";
					"Quito el cerrojo ", (al) x1, " con ", (the) second, ".";
				2:	if (~~second) "Quitas el cerrojo ", (al) x1, ".";
					"Quitas el cerrojo ", (al) x1, " con ", (the) second, ".";
				3:	if (~~second) "Quita el cerrojo ", (al) second, ".";
					"Quita el cerrojo ", (al) x1, " con ", (the) second, ".";
				4:	if (~~second) "Quit el cerrojo ", (al) x1, ".";
					"Quit el cerrojo ", (al) x1, " con ", (the) second, ".";
				5:	if (~~second) "Quitaste el cerrojo ", (al) x1, ".";
					"Quitaste el cerrojo ",(al) x1," con ", (the) second, ".";
				6:	if (~~second) "Quit el cerrojo ", (al) x1, ".";
					"Quit el cerrojo ", (al) x1, " con ", (the) second, ".";
				}
		}

	VagueGo:	!! El jugador ha escrito IR sin especificar a dnde.
		print_ret (stparser) "Tienes que especificar en qu direccin ir.";

	Verify:
		switch ( n ) {
			1:	print_ret (stparser) "Fichero de juego verificado e intacto.";
			2:	print_ret (stparser) "El fichero de juego no parece intacto, 
				puede estar corrompido (a menos que ests jugando con un 
				intrprete muy primitivo que no sea capaz de realizar la 
				comprobacin).";
		}

	Wait:
!		switch (GRAMMATICAL_FLEXION) {
!		1,2,3:	"Pasa el tiempo...";
!		4,5,6:	"Pasaba el tiempo...";
!		}
		"Haca ms fro y todo estaba ms oscuro por momentos.";

	Wake:
		switch (GRAMMATICAL_FLEXION) {
		1:	"Si esto es tan slo un sueo en realidad, no tengo la ms mnima 
			idea de cmo despertar de l.";
		2:	"Si esto es tan slo un sueo en realidad, no tienes la ms mnima 
			idea de cmo despertar de l.";
		3:	"Si esto es tan slo un sueo en realidad, no tiene la ms mnima 
			idea de cmo despertar de l.";
		4,5,6:	"La cruda realidad es que aquello no era un sueo.";
		}

	WakeOther:
		switch (GRAMMATICAL_FLEXION) {
		1: "No parece necesario que haga eso.";
		2,3: "No parece necesario hacer eso.";
		4,5,6: "No pareca necesario hacer eso.";
		}

	Wave:
		!! 1: Se intenta agitar un objeto que no est en el inventario
		!! 2: Se agita un objeto que s est en el inventario
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1: "No l", (o) x1, " tengo.";
				2: "No l", (o) x1, " tienes.";
				3: "No l", (o) x1, " tiene.";
				4: "No l", (o) x1, " tena.";
				5: "No l", (o) x1, " tenas.";
				6: "No l", (o) x1, " tena.";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1: print "Me siento";
				2: print "Te sientes";
				3: print "Se siente";
				4: print "Me vea"; 
				5: print "Te veas";
				6: print "Se vea";
				} " ridcul", (o) player, " agitando ", (the) x1, ".";
		}

	WaveHands:
		!! La accin WaveHands se genera ante las frases "gesticula", "agita la 
		!! mano", "sacude la mano", "saluda con la mano", etc.
!		switch (GRAMMATICAL_FLEXION) {
!		1: print "Me siento";
!		2: print "Te sientes";
!		3: print "Se siente";
!		4: print "Me vea"; 
!		5: print "Te veas";
!		6: print "Se vea";
!		} " ridcul", (o) player, " gesticulando as.";
		"Intent entrar en calor frotndose las manos, pero apenas sirvi de 
		nada. Segua estando helada.";

	Wear:
		!! 1: Error, el objeto no tiene el atributo "clothing".
		!! 2: Error, el jugador no tiene el objeto.
		!! 3: Error, el objeto ya tiene el atributo "worn".
		!! 4: xito.
		switch (n) {
			1:	switch (GRAMMATICAL_FLEXION) {
				1:	"No puedo ponerme eso!";
				2:	"No puedes ponerte eso!";
				3:	"No puede ponerse eso!";
				4:	"No poda ponerme eso!";
				5:	"No podas ponerte eso!";
				6:	"No poda ponerse eso!";
				}
			2:	switch (GRAMMATICAL_FLEXION) {
				1:	"No ", (lo) x1, " tengo.";
				2:	"No ", (lo) x1, " tienes.";
				3:	"No ", (lo) x1, " tiene.";
				4:	"No ", (lo) x1, " tena.";
				5:	"No ", (lo) x1, " tenas.";
				6:	"No ", (lo) x1, " tena.";
				}
			3:	switch (GRAMMATICAL_FLEXION) {
				1:	"Ya ", (lo) x1, " llevo puest", (o) x1, "!";
				2:	"Ya ", (lo) x1, " llevas puest", (o) x1, "!";
				3:	"Ya ", (lo) x1, " lleva puest", (o) x1, "!";
				4:	"Ya ", (lo) x1, " llevaba puest", (o) x1, "!";
				5:	"Ya ", (lo) x1, " llevabas puest", (o) x1, "!";
				6:	"Ya ", (lo) x1, " llevaba puest", (o) x1, "!";
				}
			4:	switch (GRAMMATICAL_FLEXION) {
				1:	"Me pongo ", (the) x1, ".";
				2:	"Te pones ", (the) x1, ".";
				3:	"Se pone ", (the) x1, ".";
				4:	"Me puse ", (the) x1, ".";
				5:	"Te pusiste ", (the) x1, ".";
				6:	"Se puso ", (the) x1, ".";
				}
		}

	Yes:
		switch (GRAMMATICAL_FLEXION) {
		1,2,3: "Es bueno ser positivo.";
		4,5,6: "Siempre ha sido bueno ser positivo.";
		}

];


!!------------------------------------------------------------------------------
!! For a SCENERY error (using a word from the NAME property of a room) due to 
!! an EXAMINE-like operation, outputs the room''s description.
!! [Extrado de "scenic.h"]
!!------------------------------------------------------------------------------
[ Handle_SCENERY_PE;
	if ( action_to_be == ##Examine or ##Search or ##Consult ) {
		if ( location.describe ~= NULL ) RunRoutines(location, describe);
		else {
			if ( location.description == 0 ) RunTimeError(11, location);
			else PrintOrRun(location, description);
		}
		InformLibrary.end_turn_sequence();
		return true;
	}
	return false;	! Error was NOT handled by this routine.
];


!!------------------------------------------------------------------------------
!! Errores del analizador
!!------------------------------------------------------------------------------
[ ParserError pe j;
	switch( pe ) {
		STUCK_PE:
					print_ret (stparser) "No se pudo entender esa instruccin.";
		UPTO_PE:
					st_parser(); 
					if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
					print "Intenta de nuevo porque solo se pudo entender que 
					quieres "; PrintCommand(); print ".";
					if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2; 
					st_normal();
					new_line; 
					return true;
		NUMBER_PE:
					print_ret (stparser) "No se entendi ese nmero.";
		CANTSEE_PE:
					print_ret (stparser) "Te has referido a algo con lo que no 
					se puede interactuar en este momento.";
		TOOLIT_PE:
					print_ret (stparser) "Parece que has indicado demasiada 
					poca cosa.";
		NOTHELD_PE:
					print_ret (stparser) "El personaje no tiene eso en su 
					poder.";
		MULTI_PE:
					st_parser(); 
					if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
					print "No se pueden especificar objetos mltiples con '", 
					(address) verb_word ,"'.";
					if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2; 
					st_normal();
					new_line; 
					return true;
		MMULTI_PE:
					print_ret (stparser) "Solo se pueden especificar objetos 
					mltiples una vez por cada lnea.";
		VAGUE_PE:
					st_parser(); 
					if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
					print "No est claro a qu te refieres con '", 
					(address) pronoun_word ,"'.";
					if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2; 
					st_normal();
					new_line; 
					return true;
		EXCEPT_PE:
					print_ret (stparser) "Has exceptuado algo que no estaba 
					includo.";
		ANIMA_PE:
					print_ret (stparser) "Solo se puede hacer eso con personas 
					u otras criaturas vivas.";
		VERB_PE:
!! Vlido nicamente para Mquina-Z
!! Revisar para Glulx
					st_parser(); 
					if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
					print "La accin '";
					for (j = 0: j < parse->4: j++)	!!in!!
						print (char) buffer->(parse->(4+1)+j);
					print "' no est definida.";
					if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2; 
					st_normal();
					new_line; 
					return true;
		SCENERY_PE:
					return Handle_SCENERY_PE();
!					print_ret (stparser) "No necesitas referirte a eso para 
!					terminar la historia.";
		ITGONE_PE:
					st_parser(); 
					if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
					print "Ahora mismo no puedes ver lo que representa el 
					pronombre '", (address) pronoun_word ,"' (", (the) 
					pronoun_obj ,").";
					if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2; 
					st_normal();
					new_line; 
					return true;
		JUNKAFTER_PE:
					print_ret (stparser) "No se pudo entender la ltima parte 
					de la orden.";
		TOOFEW_PE:
					! El jugador ha solicitado un nmero de objetos en una lista
					! de objeto mltiples, pero el analizador no es capaz de 
					! encontrar tantos. (E.j. COGE DOCE CERILLAS )
					st_parser(); 
					if ( STPARSER_MSG1 ~= 0 ) print (string) STPARSER_MSG1;
					if (multi_had == 0) print "No hay suficientes disponibles.";
					else {
						print "Solo hay ", (number) multi_had ," disponible";
						if ( multi_had ~= 1 ) print "s";
						print ".";
					}
					if ( STPARSER_MSG2 ~= 0 ) print (string) STPARSER_MSG2; 
					st_normal();
					new_line; 
					return true;
		NOTHING_PE:
					! El jugador ha puesto TODO como objeto mltiple, pero el 
					! analizador no ha encontrado ningn objeto. En realidad 
					! este error parece no producirse nunca y en realidad el que
					! acaba generndose es el siguiente (ASKSCOPE_PE).
					print_ret (stparser) "No hay nada de eso disponible.";
		default:
					return false;	! Error was NOT handled by this routine
	}
];


